/**
 * @copyright 2016 Tridium, Inc. All Rights Reserved.
 * @author Vikram Nagulan
 */

/**
 * API Status: **Private**
 * @module nmodule/ndio/rc/baja/Shunt500OhmConversion
 */
define(['baja!',
  'bajaScript/baja/obj/objUtil'], function
  (baja,
   objUtil) {

  'use strict';

  var Simple = baja.Simple,
    cacheDecode = objUtil.cacheDecode,
    cacheEncode = objUtil.cacheEncode;

  /**
   * BajaScript representation of a `ndio:Shunt500OhmConversion` value.
   *
   * @class
   * @extends {baja.Simple}
   * @alias {module:nmodule/ndio/rc/baja/Shunt500OhmConversion}
   */
  var Shunt500OhmConversion = function Shunt500OhmConversion() {
    Simple.apply(this, arguments);
  };
  Shunt500OhmConversion.prototype = Object.create(Simple.prototype);
  Shunt500OhmConversion.prototype.constructor = Shunt500OhmConversion;

  /**
   * Create a new `ndio:Shunt500OhmConversion` instance from the arguments.
   * @returns {module:nmodule/ndio/rc/baja/Shunt500OhmConversion}
   */
  Shunt500OhmConversion.make = function (proxyConvTypeSpec, encVal) {
    if (!proxyConvTypeSpec || !baja.hasType(proxyConvTypeSpec)) {
      throw new Error("Not a valid type spec");
    }
    var sc = new Shunt500OhmConversion();
    sc.$subConvTypeSpec = proxyConvTypeSpec;
    sc.$encValueStr = encVal ? encVal : "";
    return sc;
  };

  /**
   * @see .make
   * @returns {module:nmodule/ndio/rc/baja/Shunt500OhmConversion}
   */
  Shunt500OhmConversion.prototype.make = function () {
    return Shunt500OhmConversion.make.apply(Shunt500OhmConversion, arguments);
  };

  /**
   * Decode an `Shunt500OhmConversion` from a string.
   *
   * @function
   * @param {String} str
   * @returns {module:nmodule/ndio/rc/baja/Shunt500OhmConversion}
   */
  Shunt500OhmConversion.prototype.decodeFromString = cacheDecode(function (str) {
    if (!str || str.split(";").length < 2) {
      return Shunt500OhmConversion.DEFAULT;
    }

    var semi = str.indexOf(';');
    var typSpec = str.substr(0, semi);
    var encVal = str.substr(semi + 1);
    return Shunt500OhmConversion.make(typSpec, encVal);
  });

  /**
   * Encode this `Shunt500OhmConversion` to a string.
   *
   * @function
   * @returns {String}
   */
  Shunt500OhmConversion.prototype.encodeToString = cacheEncode(function () {
    return this.$subConvTypeSpec + ";" + this.$encValueStr;
  });

  Shunt500OhmConversion.prototype.getSubConvTypeSpec = function () {
    return this.$subConvTypeSpec;
  };

  Shunt500OhmConversion.prototype.getSubConvValStr = function () {
    return this.$encValueStr;
  };

  Shunt500OhmConversion.DEFAULT = Shunt500OhmConversion.make("driver:DefaultProxyConversion", "");

  baja.registerType('ndio:Shunt500OhmConversion', function () {
    return Shunt500OhmConversion;
  });

  return Shunt500OhmConversion;
});
