/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/*jshint browser: true*/
/* @noSnoop */

(function () {
  "use strict";

  var res,
      themeName,
      $ = window.jQuery;

  function loadTheme() {
    var name = encodeURIComponent($("#theme").val()),
        res = /^([^?]+)/.exec(window.location.href),
        uri = res && res.length > 1 ? (res[1] + "?theme=" + name) : "";

    if (uri) {
      window.location.assign(uri);
    }
    return false;
  }

  // Search any parameters for theme and if 'theme' is found, captilize 
  // the first letter and dynamically inject the style sheet.
  if (location.search) {
    res = /\??.*&?theme=([^&]+)&?.*/.exec(location.search);
    if (res && res.length > 1) {
      themeName = res[1];
      if (themeName) {
        themeName = decodeURIComponent(themeName);

        // Make sure the first letter is a capital
        themeName = themeName.replace(/^./, function (s) {
          return s.toUpperCase();
        });

        $("#theme").val(themeName);

        $("head:first")
          .append("<link rel='stylesheet' type='text/css' href='/module/theme" + themeName + "/ux/theme.css'>")
          .append("<link rel='stylesheet' type='text/css' href='/module/theme" + themeName + "/sprite/sprite.css'>");
        
      }
    }
  }

  // When the user clicks the 'Load' button, dynamically load a theme into the page.
  $(function () {
    $("#loadTheme").click(loadTheme);
    $("#theme").keyup(function (ev) {
      // Handle when the enter key is pressed
      if (ev && ev.keyCode === 13) {
        loadTheme();
      }
    });
  });

}());
