/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/report/rc/fe/GridPaginationModel
 */
define(['nmodule/webEditors/rc/wb/table/model/ComponentTableModel', 'nmodule/webEditors/rc/wb/table/model/source/ArrayComponentSource', 'nmodule/webEditors/rc/wb/table/pagination/PaginationModel'], function (ComponentTableModel, ArrayComponentSource, PaginationModel) {
  'use strict';
  /**
   * @class
   * @alias module:nmodule/report/rc/fe/GridPaginationModel
   * @extends module:nmodule/webEditors/rc/wb/table/pagination/PaginationModel
   * @param {object} params
   * @param {module:nmodule/report/rc/fe/GridPaginationHandler} params.handler
   */

  var GridPaginationModel = function GridPaginationModel(params) {
    PaginationModel.apply(this, arguments);
    this.$handler = params.handler;
  };

  GridPaginationModel.prototype = Object.create(PaginationModel.prototype);
  GridPaginationModel.prototype.constructor = GridPaginationModel;

  GridPaginationModel.prototype.makeTableModel = function (rowStart, rowEnd) {
    var handler = this.$handler,
        subscriber = handler.$params.subscriber;
    return subscriber.unsubscribeAll().then(function () {
      return handler.$resolveRange(rowStart, rowEnd);
    });
  };

  return GridPaginationModel;
});
