/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */

/* global hx */

/**
 * ColorChooser.
 *
 * @author    Andy Frank
 * @creation  24 Feb 06
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

////////////////////////////////////////////////////////////////
// ColorChooser
////////////////////////////////////////////////////////////////

var colorChooser = new ColorChooser(); // global instance
function ColorChooser()
{
  var def = [
  // Red
    "#ff0000",
    "#400000",
    "#800000",
    "#c00000",
    "#ff4040",
    "#ff8080",
    "#ffc0c0",
    "#000000",

  // Orange
    "#ff8000",
    "#402000",
    "#804000",
    "#bf6000",
    "#ffa040",
    "#ffc080",
    "#ffdfbf",
    "#202020",

  // Yellow
    "#ffff00",
    "#404000",
    "#808000",
    "#c0c000",
    "#ffff40",
    "#ffff80",
    "#ffffc0",
    "#404040",

  // Green
    "#00ff00",
    "#004000",
    "#008000",
    "#00c000",
    "#40ff40",
    "#80ff80",
    "#c0ffc0",
    "#606060",

  // Cyan
    "#00ffff",
    "#004040",
    "#008080",
    "#00c0c0",
    "#40ffff",
    "#80ffff",
    "#c0ffff",
    "#808080",

  // Aqua ?
  /*
    "#0080ff",
    "#002040",
    "#004080",
    "#0060bf",
    "#40a0ff",
    "#80c0ff",
    "#bfdfff",      
    "#b0b0b0",
  */

  // Blue
    "#0000ff",
    "#000040",
    "#000080",
    "#0000c0",
    "#4040ff",
    "#8080ff",
    "#c0c0ff",
    "#c0c0c0",

  // Purple
    "#8000ff",
    "#1e0040",
    "#3c0080",
    "#5a00c0",
    "#9a41ff",
    "#bb80ff",
    "#ddbfff",
    "#e0e0e0",

  // Magenta
    "#ff00ff",
    "#400040",
    "#800080",
    "#c000c0",
    "#ff40ff",
    "#ff80ff",
    "#ffc0ff",
    "#ffffff"
  ];

  /**
   * Show the color chooser.
   */
  this.show = function(handler)
  {
    // Reset default color
    this.selected = "#ff0000";
    
    this.handler = handler;
    var body = "";
    body += "<table>";
    body += "<tr>";
    body += "<td>";
    body += makeDefaultPalette();
    body += "</td>";
    body += "<td valign='top'>";
    body += makeSwatch();
    body += "</td>";
    body += "</tr>";
    body += "</table>";
    hx.showDialog(chrome(body));
  }
  
  /**
   * Commit color selection by calling handler.
   */
  this.commit = function()
  {
    if (colorChooser.handler != null)
      colorChooser.handler(colorChooser.selected);
  }
  
////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  /**
   * Add chrome for the dialog around body.
   */
  function chrome(body)
  {
    var c = "<table border='0' align='center' height='100%'>";
    c += "<tr><td valign='middle'>";
    c += "<div class='control-bg dialog-outerBorder'>";
    c += "<div class='dialog-innerBorder'>";
    
    // Titlebar
    c += "<div class='dialog-header'>Color Chooser</div>";
    
    // Padding
    c += "<div class='dialog-content'>";
    
    // Content
    c += body;
    
    // Buttons
    c += "<div style='padding-top:10px; text-align:center;'>";
    c += "<input type='button' class='button' value='Ok' ";
    c += "onclick='hx.closeDialog(null, null); colorChooser.commit();' />";
    c += " <input type='button' class='button' value='Cancel' ";
    c += "onclick='hx.closeDialog(null, null);' />";
    c += "</div>";
      
    // End padding
    c += "</div>";
    
    // End dialog
    c += "</div>"; // inner border
    c += "</div>"; // outer border
    c += "</td></tr>";
    c += "</table>";
    
    return c;
  }
  
  /**
   * Create default palette.
   */
  function makeDefaultPalette()
  {         
    var p = "<div style='position:relative; background:black; ";      
    p += "width:137px; height:137px;'>";
    
    var cols = 8;
    var rows = 8;
    
    for (var r=0; r<rows; r++)
      for (var c=0; c<cols; c++)
      {
        var i = (r * 8)  + c;
        var x = (c * 17) + 1;
        var y = (r * 17) + 1;
        
        var val = def[i];
        
        p += "<div style='position:absolute; ";
        p += "left:" + x + "px; top:" + y + "px; ";
        p += "width:16px; height:16px; cursor:pointer; ";
        p += "background:" + val + ";'";
        p += "onclick='colorChooser.update(\"" + val + "\");'>";
        p += "</div>";
      }
    
    p += "</div>";
    return p;
  }
  
  /**
   * Make the current selected swatch.
   */
  function makeSwatch()
  {
    var s = "<div id='colorChooserSwatch' ";
    s += "style='width:48px; height:48px; background:#f00;";
    s += " border: 1px solid black;' ></div>";
    return s;
  }
  
  /**
   * Update selected color.
   */
  this.update = function(val)
  {
    colorChooser.selected = val;
    hx.$("colorChooserSwatch").style.background = val;
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  this.selected = "#ff0000";
}

