/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */ 
package javax.baja.workbench.util;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.pane.BEdgePane;
import com.tridium.workbench.util.NotifyManager;

/**
 * BNotifyPane is used for async notifications.
 * 
 * @author    Andy Frank
 * @creation  26 Jul 04
 * @version   $Revision: 2$ $Date: 3/28/05 1:41:02 PM EST$
 * @since     Baja 1.0
 */
public class BNotifyPane
  extends BEdgePane
{ 
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNotifyPane.class);
  
////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////
  
  /**
   * Open notification pane with default timeout.
   */
  public void open()
  {
    open(DEFAULT_TIMEOUT);
  }
  
  /**
   * Open notification pane with given timeout in 
   * millis. Use -1 to disable timeout.
   */
  public void open(int timeout)
  {
    NotifyManager.get().open(this, timeout);
  }
  
  /**
   * Close the notification window.
   */  
  public void close()
  {
    NotifyManager.get().close(this);
  }  
  
////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  /** Default timeout in millis. */
  private static final int DEFAULT_TIMEOUT = 5000;
}

