/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.workbench.sidebar;

import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

/**
 * BIWbSideBar represents an interface to installed sidebars in workbench
 * @author: Danesh Kamal
 * @date: 1/19/14
 * @since: Niagara 4.0
 */
public interface BIWbSideBar extends BInterface
{

  public static final Type TYPE = Sys.loadType(BIWbSideBar.class);

  /**
   * Get an array of TypeInfos for all the implementations
   * of BIWbSideBar currently installed on the system.
   */
  public TypeInfo[] getInstalledSideBars();

  /**
   * @return true if this sidebar should have a 'Close' command.
   */
  public boolean hasCloseCommand();

  /**
   * This callback is invoked when the active view is
   * modified via a hyperlink operation.
   */
  public void activeViewChanged();

  /**
   * Get the sidebar label
   * @return
   */
  public String getLabel();

  /**
   * Get the sidebar icon
   * @return
   */
  public BIcon getIcon();

  /**
   * Return the sidebar as a BWidget
   * @return
   */
  public BWidget asWidget();

}
