/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.workbench.mgr.tag;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * @author    Andrew Saunders
 * @creation 3/22/14
 * @since Niagara 4.0
 */
public final class BTagFilterEnum
  extends BFrozenEnum
{
  /*-

  enum BTagFilterEnum
  {

    range
    {
      showAll,
      validOnly,
      bestOnly,
    }

  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.workbench.mgr.tag.BTagFilterEnum(952738833)1.0$ @*/
/* Generated Sat Mar 22 09:04:19 EDT 2014 by Slot-o-Matic (c) Tridium, Inc. 2012 */
  
  /** Ordinal value for showAll. */
  public static final int SHOW_ALL = 0;
  /** Ordinal value for validOnly. */
  public static final int VALID_ONLY = 1;
  /** Ordinal value for bestOnly. */
  public static final int BEST_ONLY = 2;
  
  /** BTagFilterEnum constant for showAll. */
  public static final BTagFilterEnum showAll = new BTagFilterEnum(SHOW_ALL);
  /** BTagFilterEnum constant for validOnly. */
  public static final BTagFilterEnum validOnly = new BTagFilterEnum(VALID_ONLY);
  /** BTagFilterEnum constant for bestOnly. */
  public static final BTagFilterEnum bestOnly = new BTagFilterEnum(BEST_ONLY);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTagFilterEnum.class);
  
  /** Factory method with ordinal. */
  public static BTagFilterEnum make(int ordinal)
  {
    return (BTagFilterEnum)showAll.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BTagFilterEnum make(String tag)
  {
    return (BTagFilterEnum)showAll.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BTagFilterEnum(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BTagFilterEnum DEFAULT = showAll;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
