/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.workbench.celleditor;

import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;

/**
 * BDropDownCE 
 *
 * @author    Mike Jarmy
 * @creation  08 May 07
 * @version   $Revision: 1$ $Date: 8/15/07 3:38:59 PM EDT$
 * @since     Baja 1.0
 */
 
public abstract class BDropDownCE
  extends BWbCellEditor
{ 
  /*-
  
  class BDropDownCE
  {
    actions
    {  
      dropDownModified(event: BWidgetEvent)
        default {[ new BWidgetEvent() ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.workbench.celleditor.BDropDownCE(2923625567)1.0$ @*/
/* Generated Tue Aug 14 17:00:39 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Action "dropDownModified"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>dropDownModified</code> action.
   * @see javax.baja.workbench.celleditor.BDropDownCE#dropDownModified()
   */
  public static final Action dropDownModified = newAction(0,new BWidgetEvent(),null);
  
  /**
   * Invoke the <code>dropDownModified</code> action.
   * @see javax.baja.workbench.celleditor.BDropDownCE#dropDownModified
   */
  public void dropDownModified(BWidgetEvent event) { invoke(dropDownModified,event,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDropDownCE.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// BWbEditor
////////////////////////////////////////////////////////////////

  /**
   * doSetReadonly
   */
  protected void doSetReadonly(boolean readonly)
  {
    getDropDown().setDropDownEnabled(!readonly);
    getDropDown().setEnabled(!readonly);
  }

////////////////////////////////////////////////////////////////
// BWidget
////////////////////////////////////////////////////////////////
  
  /**
   * doLayout
   */
  public void doLayout(BWidget[] children)
  {
    getDropDown().setBounds(0, 2, getWidth()-1, getHeight()-2);
  }

  /**
   * paint
   */
  public void paint(Graphics g)
  {
    paintBackground(g);

    super.paint(g);    
  }

////////////////////////////////////////////////////////////////
// actions
////////////////////////////////////////////////////////////////

  public void doDropDownModified(BWidgetEvent event)
  {
    setModified();
  }

////////////////////////////////////////////////////////////////
// access
////////////////////////////////////////////////////////////////

  public abstract BDropDown getDropDown();
}
