/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.naming.BISession;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.text.PasswordRenderer;
import javax.baja.ui.text.PasswordTextController;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import com.tridium.workbench.auth.PasswordUtils;
import com.tridium.workbench.util.WbUtil;

/**
 * BPasswordFE allows viewing and editing of a BPassword
 * using a text field with a PasswordRenderer.
 *
 * @author    Brian Frank       
 * @creation  22 Jan 01
 * @version   $Revision: 6$ $Date: 7/30/10 2:42:12 PM EDT$
 * @since     Baja 1.0
 */
public class BPasswordFE
  extends BWbFieldEditor
{ 
  /*-
  class BPasswordFE
  {
    actions
    {
      modified()
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.workbench.fieldeditors.BPasswordFE(4018710654)1.0$ @*/
/* Generated Wed May 07 17:49:18 EDT 2003 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Action "modified"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>modified</code> action.
   * @see com.tridium.workbench.fieldeditors.BPasswordFE#modified()
   */
  public static final Action modified = newAction(0,null);
  
  /**
   * Invoke the <code>modified</code> action.
   * @see com.tridium.workbench.fieldeditors.BPasswordFE#modified
   */
  public void modified() { invoke(modified,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPasswordFE.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////
  
  public BPasswordFE()
  {
    BTextField field = new BTextField("", 20);
    field.setRenderer(new PasswordRenderer());
    field.setController(new PasswordTextController());
    field.setAllowCopying(false);
    linkTo("linkA", field, BTextField.textModified, modified);
    linkTo("linkB", field, BTextField.textModified, setModified);
    linkTo("linkC", field, BTextField.actionPerformed, actionPerformed);
    setContent(field);
  }

  public void started()
    throws Exception
  {
    super.started();

    //now that widget has a parent, we might be able to get to widget tree ancestor with access to the session
    checkPasswordChangeAllowed();
  }

////////////////////////////////////////////////////////////////
// WbEditor 
////////////////////////////////////////////////////////////////

  protected void doSetReadonly(boolean readonly)
  {
    ((BTextField)getContent()).setEditable(!readonly);
  }
  
  protected void doLoadValue(BObject value, Context cx)
  {
    BTextField field = (BTextField)getContent();
    BPassword pw = (BPassword)value;

    String s = pw.isDefault() ? "" : "        ";

    field.setText(s);
    changed = false;
    checkPasswordChangeAllowed();
  }

  /**
   * If a session can be found. check to see if changing passwords is allowed. If its not, make the widget readonly.
   * @since Niagara 4.0
   */
  public void checkPasswordChangeAllowed()
  {
    if(isReadonly())
      return;

    BISession session = null;
    BComponent c = (BComponent) WbUtil.findAncenstorViaWidgetTree(this, BComponent.TYPE, true);
    if(c != null)
      session = c.getSession();

    if (!PasswordUtils.isPasswordChangeAllowed(session))
    {
      setReadonly(true);
    }
  }

  protected BObject doSaveValue(BObject value, Context cx)
  {
    if (changed)
    {
      String str = ((BTextField)getContent()).getText();
      return BPassword.make(str, cx);
    }
    else return getCurrentValue();
  }

  public boolean isChanged()
  {
    return changed;
  }

  public void doModified() { changed = true; }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  private boolean changed = false;
}
