/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

/**
 * BFrozenEnumFE allows editing of BFrozenEnum.
 *
 * @author    Brian Frank       
 * @creation  13 Dec 01
 * @version   $Revision: 3$ $Date: 3/28/05 1:40:35 PM EST$
 * @since     Baja 1.0
 */
public class BFrozenEnumFE
  extends BWbFieldEditor
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFrozenEnumFE.class);

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BFrozenEnumFE()
  {    
    setContent(combo);
    linkTo("lk0", combo, BTextDropDown.valueModified, setModified);
    linkTo("lk1", combo, BTextDropDown.actionPerformed, actionPerformed);
  }

////////////////////////////////////////////////////////////////
// BWbEditor
////////////////////////////////////////////////////////////////

  protected void doSetReadonly(boolean readonly)
  {
    combo.setDropDownEnabled(!readonly);
  }  

  protected void doLoadValue(BObject v, Context cx)
  { 
    // save fields
    this.val = (BEnum)v;
    this.range = val.getRange();
    this.ordinals = range.getOrdinals();
    
    // populate list
    int sel = -1;
    combo.getList().removeAllItems();
    for(int i=0; i<ordinals.length; ++i)
    {
      int ordinal = ordinals[i];
      String displayTag = range.getDisplayTag(ordinal, null);
      combo.getList().addItem(displayTag);
      if (ordinal == val.getOrdinal()) sel = i;
    }               
    
    // set current index
    combo.setSelectedIndex(sel);
  }
  
  protected BObject doSaveValue(BObject v, Context cx)
  {                
    int sel = combo.getSelectedIndex();
    return range.get(ordinals[sel]);
  }        
    
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////  

  private BListDropDown combo = new BListDropDown();
  private BEnum val;
  private BEnumRange range; 
  private int[] ordinals;
  
}
