/*
 * Copyright 2007 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBlob;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

/**
 * BBlobFE allows viewing and editing of a BBlob where
 * the bytes are entered and displayed in hex.
 *
 * @author    Andy Frank       
 * @creation  20 Dec 07
 * @version   $Revision: 1$ $Date: 12/20/07 9:51:52 AM EST$
 * @since     Niagara 3.4
 */
public class BBlobFE
  extends BWbFieldEditor
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBlobFE.class);

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBlobFE()
  {    
    BGridPane grid = new BGridPane(2);
    grid.add(null, new BLabel("0x"));
    grid.add(null, field = new BTextField());
    setContent(grid);    
    
    linkTo(field, BTextEditor.textModified, setModified);
    linkTo(field, BTextField.actionPerformed, actionPerformed);
  }

////////////////////////////////////////////////////////////////
// BWbEditor
////////////////////////////////////////////////////////////////
  
  protected void doSetReadonly(boolean readonly)
  {
    field.setEditable(!readonly);
  }  

  protected void doLoadValue(BObject value, Context cx)
  {
    BBlob blob = (BBlob)value;
    byte[] bytes = blob.copyBytes();
    
    StringBuffer s = new StringBuffer(bytes.length*2);
    for (int i=0; i<bytes.length; i++)
      s.append(TextUtil.byteToHexString(bytes[i]));
    field.setText(s.toString());
  }
  
  protected BObject doSaveValue(BObject value, Context cx)
  {
    String s = field.getText();
    
    int len = s.length();
    boolean odd = len % 2 != 0;
    if (odd) len++;
    len = len / 2;    
    byte[] bytes = new byte[len];

    for (int i=0,j=0; i<s.length();)
    {
      int h,l;      
      if (i == 0 && odd)
      {    
        h = 0;
        l = TextUtil.hexCharToInt(s.charAt(i++));
      }
      else
      {
        h = TextUtil.hexCharToInt(s.charAt(i++));
        l = TextUtil.hexCharToInt(s.charAt(i++));
      }      
      bytes[j++] = (byte)((h << 4) | l);
    }
  
    return BBlob.make(bytes);
  }

////////////////////////////////////////////////////////////////
// Fields
////////////////////////////////////////////////////////////////

  BTextField field;
    
}
