/*
 * Copyright 2011, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.web.mobile;

import javax.baja.agent.BIAgent;
import javax.baja.naming.BOrd;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Mobile Views may expose some public API that allows the View to be extended. 
 * If a Mobile View supports this, the View may be extended by extending this class
 * and registering it as an Agent on the target Mobile View.
 *
 * @author		gjohnson
 * @creation 	25 Oct 2011
 * @version 	1
 * @since 		Niagara 3.7
 */
public abstract class BMobileWebViewExt 
    extends BSingleton
    implements BIAgent
{
/*-
  class BMobileWebViewExt
  {
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.web.mobile.BMobileWebViewExt(1657083815)1.0$ @*/
/* Generated Tue Oct 25 16:49:40 BST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BMobileWebViewExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  /**
   * Return a list of ORDs that map to JavaScript resources to include in a given Mobile View. 
   * <p>
   * Please note that not all Mobile Views may support this and only 
   * CSS/APIs exposed as public should be used to extend a Mobile View.
   * 
   * @param profile
   * @param view
   * @param cx
   * @return an array of ORDS that will map to JavaScript resources to be included in a Mobile View.
   */
  public abstract BOrd[] getJavaScriptResources(BMobileWebProfile profile, BIMobileWebView view, Context cx);
  
  /**
   * Return a list of ORDs that map to CSS resources to include in a given Mobile View. 
   * <p>
   * Please note that not all Mobile Views may support this and only 
   * CSS/APIs exposed as public should be used to extend a Mobile View.
   * 
   * @param profile
   * @param view
   * @param cx
   * @return an array of ORDS that will map to CSS resources to be included in a Mobile View.
   */
  public abstract BOrd[] getCssResources(BMobileWebProfile profile, BIMobileWebView view, Context cx);
}
