/*
 * Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.web;

import com.tridium.web.*;
import javax.baja.license.*;
import javax.baja.sys.*;
import javax.baja.web.mobile.*;

/**
 * A list of supported web client environments.  Environments in the list are evaluated in
 * order to determine if the one of the environments matches the environment of the
 * requesting client.  A match is typically determined by evaluating the user-agent
 * in the web request.
 * <p/>
 * If no match is found, the default client environment is used.  The default is
 * the desktop environment which allows any available web profile to be used
 * to service the request.
 * 
 * @author    John Sublett
 * @creation  01 Apr 2012
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */
public class BClientEnvironments
  extends BVector
{
  /*-
  
  class BClientEnvironments
  {
    properties
    {
      envServlet: BClientEnvServlet
        flags { hidden }
        default {[ new BClientEnvServlet() ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.web.BClientEnvironments(1476217316)1.0$ @*/
/* Generated Wed Apr 04 09:43:51 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "envServlet"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>envServlet</code> property.
   * @see javax.baja.web.BClientEnvironments#getEnvServlet
   * @see javax.baja.web.BClientEnvironments#setEnvServlet
   */
  public static final Property envServlet = newProperty(Flags.HIDDEN, new BClientEnvServlet(),null);
  
  /**
   * Get the <code>envServlet</code> property.
   * @see javax.baja.web.BClientEnvironments#envServlet
   */
  public BClientEnvServlet getEnvServlet() { return (BClientEnvServlet)get(envServlet); }
  
  /**
   * Set the <code>envServlet</code> property.
   * @see javax.baja.web.BClientEnvironments#envServlet
   */
  public void setEnvServlet(BClientEnvServlet v) { set(envServlet,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BClientEnvironments.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public final void started()
  {
    try
    {
      // automatically add the MobileClientEnvironment if the "mobile" feature
      // is licensed
      Feature mobileFeature = Sys.getLicenseManager().getFeature("Tridium", "mobile");
      if ((mobileFeature != null) && !mobileFeature.isExpired() && BMobileClientEnvironment.isMobileAvailable())
      {
        if (get("mobile") == null)
          add("mobile", new BMobileClientEnvironment());
      }
    }
    catch (FeatureNotLicensedException ex)
    {
      // silently do nothing if not licensed
    }
  }

  /**
   * Get the IWebEnv for the specified web request.
   */
  public IWebEnv getWebEnv(WebOp op)
  {
    // first check the session to see if an environment has already been selected
    IWebEnv webEnv = (IWebEnv)op.getRequest().getSession(true).getAttribute("webenv");
    if (webEnv != null)
      return webEnv;
    
    // if no environment has been selected, walk through the children and check
    // each client environment for a match
    SlotCursor<Property> c = getProperties();
    while (c.next(BClientEnvironment.class))
    {
      BClientEnvironment clientEnv = (BClientEnvironment)c.get();
      webEnv = clientEnv.matchWebEnv(op);
      if (webEnv != null)
        break;
    }

    // if no IWebEnv was found, use the BDefaultClientEnvironment to
    // get the IWebEnv
    if (webEnv == null)
    {
      webEnv = new BDefaultClientEnvironment().getWebEnv(op);
    }

    op.getRequest().getSession(true).setAttribute("webenv", webEnv);
    return webEnv;
  }
}
