/*
 * Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.web;

import com.tridium.sys.schema.*;
import javax.baja.status.*;
import javax.baja.sys.*;
import javax.baja.user.*;

/**
 * BClientEnvironment provides support for a web client environment.  A client environment
 * is selected by passing a web request (WebOp) to each available BClientEnvironment and
 * allowing the first matching environment to provide a web profile.
 * <p/>
 * The available client environments are listed under the clientEnvs property of the
 * WebService.
 * 
 * @author    John Sublett
 * @creation  01 Apr 2012
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */
public abstract class BClientEnvironment
  extends BComponent
  implements BIStatus
{
  /*-
  
  class BClientEnvironment
  {
    properties
    {
      enabled: boolean
        default {[ true ]}
      status: BStatus
        flags { transient, readonly }
        default {[ BStatus.ok ]}
      faultCause: String
        flags { transient, readonly }
        default {[ "" ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.web.BClientEnvironment(4113231454)1.0$ @*/
/* Generated Thu Apr 05 13:55:23 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "enabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>enabled</code> property.
   * @see javax.baja.web.BClientEnvironment#getEnabled
   * @see javax.baja.web.BClientEnvironment#setEnabled
   */
  public static final Property enabled = newProperty(0, true,null);
  
  /**
   * Get the <code>enabled</code> property.
   * @see javax.baja.web.BClientEnvironment#enabled
   */
  public boolean getEnabled() { return getBoolean(enabled); }
  
  /**
   * Set the <code>enabled</code> property.
   * @see javax.baja.web.BClientEnvironment#enabled
   */
  public void setEnabled(boolean v) { setBoolean(enabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "status"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>status</code> property.
   * @see javax.baja.web.BClientEnvironment#getStatus
   * @see javax.baja.web.BClientEnvironment#setStatus
   */
  public static final Property status = newProperty(Flags.TRANSIENT|Flags.READONLY, BStatus.ok,null);
  
  /**
   * Get the <code>status</code> property.
   * @see javax.baja.web.BClientEnvironment#status
   */
  public BStatus getStatus() { return (BStatus)get(status); }
  
  /**
   * Set the <code>status</code> property.
   * @see javax.baja.web.BClientEnvironment#status
   */
  public void setStatus(BStatus v) { set(status,v,null); }

////////////////////////////////////////////////////////////////
// Property "faultCause"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>faultCause</code> property.
   * @see javax.baja.web.BClientEnvironment#getFaultCause
   * @see javax.baja.web.BClientEnvironment#setFaultCause
   */
  public static final Property faultCause = newProperty(Flags.TRANSIENT|Flags.READONLY, "",null);
  
  /**
   * Get the <code>faultCause</code> property.
   * @see javax.baja.web.BClientEnvironment#faultCause
   */
  public String getFaultCause() { return getString(faultCause); }
  
  /**
   * Set the <code>faultCause</code> property.
   * @see javax.baja.web.BClientEnvironment#faultCause
   */
  public void setFaultCause(String v) { setString(faultCause,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BClientEnvironment.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  /**
   * Examines the specified web request and returns an appropriate IWebEnv
   * to handle the request.  If this environment is not a match
   * for the specified web request, null is returned.
   *
   * @param webOp The web request to match.
   * @return If the web request matches this environment, an IWebEnv is returned.
   *   If the requesting environment does not match, or if the ClientEnvironment
   *   is disabled or in fault status, null is returned.
   */
  public final IWebEnv matchWebEnv(WebOp webOp)
  {
    if (getStatus().isDisabled() || getStatus().isFault())
      return null;
    else
      return doMatchWebEnv(webOp);
  }
  
  /**
   * Examines the specified web request and returns an appropriate IWebEnv
   * to handle the request.  If this environment is not a match
   * for the specified web request, null is returned.
   *
   * @param webOp The web request to match.
   * @return If the web request matches this environment, an IWebEnv is returned.
   *   If the requesting environment does not match, null is returned.
   */
  protected abstract IWebEnv doMatchWebEnv(WebOp webOp);

  /**
   * Get the IWebEnv associated with this ClientEnvironment.  In some cases
   * the IWebEnv depends on information provided by the WebOp (ex. the user).
   *
   * @return The associated IWebEnv or null if the ClientEnvironment
   *   is disabled.
   */
  public final IWebEnv getWebEnv(WebOp op)
  {
    if (getStatus().isDisabled())
      return null;
    else
      return doGetWebEnv(op);
  }

  /**
   * Get the IWebEnv associated with this ClientEnvironment.
   */
  protected abstract IWebEnv doGetWebEnv(WebOp op);

  public void started()
  {
    if (!getEnabled())
      updateStatus(BStatus.makeDisabled(getStatus(), true), null);
  }

  /**
   * Handle a property change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p.equals(enabled))
    {
      updateStatus(BStatus.makeDisabled(getStatus(), !getEnabled()), null);
    }
    else
      super.changed(p, cx);
  }

  /**
   * Callback allows subclasses to override status changes.  Subclasses
   * must call super.updateStatus().
   *
   * @param newStatus The new status bits to set for this environment.
   * @param faultCause The new fault cause.  If null, fault cause is
   *   not changed.
   */
  protected void updateStatus(BStatus newStatus, String faultCause)
  {
    setStatus(newStatus);
    if (faultCause != null)
      setFaultCause(faultCause);
  }
}