/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.web;

import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * This class enumerates the different options for caching modules when using the
 * applet.
 *
 * <p>The options are:
 * <ul>
 *   <li>host: the client will have a module cache for each host visited</li>
 *   <li>user: the client will generally use a single module cache per user, but
 *       will fall back to the host cache if there's a conflict (e.g. trying to download
 *       a module already in the cache, but that has a different timestamp)</li>
 * </ul>
 * </p>
 *
 * @author Melanie Coggan
 * @creation 2015-09-11
 * @since Niagara 4.1
 */
@NiagaraType
public final class BAppletModuleCachingType
        extends BFrozenEnum
{
  /*-
  enum BAppletModuleCachingType
  {
    range
    {
      host,
      user
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.web.BAppletModuleCachingType(4189973479)1.0$ @*/
/* Generated Fri Sep 11 14:35:54 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */
  
  /** Ordinal value for host. */
  public static final int HOST = 0;
  /** Ordinal value for user. */
  public static final int USER = 1;
  
  /** BAppletModuleCachingType constant for host. */
  public static final BAppletModuleCachingType host = new BAppletModuleCachingType(HOST);
  /** BAppletModuleCachingType constant for user. */
  public static final BAppletModuleCachingType user = new BAppletModuleCachingType(USER);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAppletModuleCachingType.class);
  
  /** Factory method with ordinal. */
  public static BAppletModuleCachingType make(int ordinal)
  {
    return (BAppletModuleCachingType)host.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BAppletModuleCachingType make(String tag)
  {
    return (BAppletModuleCachingType)host.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BAppletModuleCachingType(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BAppletModuleCachingType DEFAULT = host;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
