/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.serial;

import javax.baja.sys.*;

/**
 * BSerialParity represents the parity bit settings
 * for a comm port.
 * <p>
 *
 * @author    Scott Hoye
 * @creation  22 Mar 02
 * @version   $Revision: 5$ $Date: 3/31/04 11:52:52 AM EST$  
 * @since     Niagara 3.0 serial 1.0
 */

public final class BSerialParity
  extends BFrozenEnum
{
  /*-
  enum BSerialParity
  {
    range
    {
      none = 0,
      odd = 1,
      even = 2,
      mark = 3,
      space = 4
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.serial.BSerialParity(2616863558)1.0$ @*/
/* Generated Tue Jul 10 12:06:34 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for none. */
  public static final int NONE = 0;
  /** Ordinal value for odd. */
  public static final int ODD = 1;
  /** Ordinal value for even. */
  public static final int EVEN = 2;
  /** Ordinal value for mark. */
  public static final int MARK = 3;
  /** Ordinal value for space. */
  public static final int SPACE = 4;
  
  /** BSerialParity constant for none. */
  public static final BSerialParity none = new BSerialParity(NONE);
  /** BSerialParity constant for odd. */
  public static final BSerialParity odd = new BSerialParity(ODD);
  /** BSerialParity constant for even. */
  public static final BSerialParity even = new BSerialParity(EVEN);
  /** BSerialParity constant for mark. */
  public static final BSerialParity mark = new BSerialParity(MARK);
  /** BSerialParity constant for space. */
  public static final BSerialParity space = new BSerialParity(SPACE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSerialParity.class);
  
  /** Factory method with ordinal. */
  public static BSerialParity make(int ordinal)
  {
    return (BSerialParity)none.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BSerialParity make(String tag)
  {
    return (BSerialParity)none.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BSerialParity(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BSerialParity DEFAULT = BSerialParity.none;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}