/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.serial;

import javax.baja.sys.*;

/**
 * BSerialDataBits represents the number of databits
 * for a serial port.
 * <p>
 *
 * @author    Scott Hoye
 * @creation  22 Mar 02
 * @version   $Revision: 5$ $Date: 3/31/04 11:52:47 AM EST$  
 * @since     Niagara 3.0 serial 1.0
 */

public final class BSerialDataBits
  extends BFrozenEnum
{
  /*-
  enum BSerialDataBits
  {
    range
    {
      dataBits8 = 8,
      dataBits7 = 7,
      dataBits6 = 6,
      dataBits5 = 5
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.serial.BSerialDataBits(749222742)1.0$ @*/
/* Generated Tue Jul 10 12:06:34 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for dataBits8. */
  public static final int DATA_BITS_8 = 8;
  /** Ordinal value for dataBits7. */
  public static final int DATA_BITS_7 = 7;
  /** Ordinal value for dataBits6. */
  public static final int DATA_BITS_6 = 6;
  /** Ordinal value for dataBits5. */
  public static final int DATA_BITS_5 = 5;
  
  /** BSerialDataBits constant for dataBits8. */
  public static final BSerialDataBits dataBits8 = new BSerialDataBits(DATA_BITS_8);
  /** BSerialDataBits constant for dataBits7. */
  public static final BSerialDataBits dataBits7 = new BSerialDataBits(DATA_BITS_7);
  /** BSerialDataBits constant for dataBits6. */
  public static final BSerialDataBits dataBits6 = new BSerialDataBits(DATA_BITS_6);
  /** BSerialDataBits constant for dataBits5. */
  public static final BSerialDataBits dataBits5 = new BSerialDataBits(DATA_BITS_5);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSerialDataBits.class);
  
  /** Factory method with ordinal. */
  public static BSerialDataBits make(int ordinal)
  {
    return (BSerialDataBits)dataBits8.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BSerialDataBits make(String tag)
  {
    return (BSerialDataBits)dataBits8.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BSerialDataBits(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BSerialDataBits DEFAULT = BSerialDataBits.dataBits8;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}