/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.serial;

import javax.baja.sys.*;

/**
 * The BISerialService is the public API used to lookup serial ports
 *
 *
 * @author    Dan Giorgis
 * @creation  03 Feb 04
 * @version   $Revision: 5$ $Date: 3/28/05 11:40:35 AM EST$
 * @since     Baja 1.0
 */
public interface BISerialService
  extends BIService
{  
  /**
   * Lazy-loads serial service properties.
   * 
   * This must be called before any getters are used, otherwise
   * they can return inaccurate results.
   */
  public void checkPropertiesLoaded();

  /**
   *  Returns array of all port names on the platform
   */
  public String[] getPortNames();  
  
  /**
   * Return the current owner for the given port
   */
  public String getCurrentOwner(String portName)
    throws PortNotFoundException;
  
  /**
   *  Open port for use by the given owner.
   *  The port may be released by calling BSerialPort.close();
   */  
  public BISerialPort openPort(String port, String owner)
    throws PortNotFoundException, PortDeniedException;
    
  /** 
   *  Get the mimimum receive timeout supported on the platform
   */
  public int getMinTimeout();
       
  public static final Type TYPE = Sys.loadType(BISerialService.class);

}