/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.serial;

import java.io.*;
import javax.baja.sys.*;

/**
 * The BISerialPort is the public API used to access serial ports
 *
 *
 * @author    Dan Giorgis
 * @creation  03 Feb 04
 * @version   $Revision: 4$ $Date: 5/23/05 1:20:35 PM EDT$
 * @since     Baja 1.0
 */
public interface BISerialPort
  extends BInterface
{  
  /**
   *  Once close is called, the BISerialPort reference becomes invalid.
   *  All further method invocations will result in a PortClosedException
   */
  public void close();

  public String getOwner();
  
  public String getOsPortName();
     
  public void sendBreak(int millis);
  
  public void setFlowControlMode(BSerialFlowControlMode flowcontrol) throws UnsupportedOperationException;
  public BSerialFlowControlMode getFlowControlMode();

  public BBaudRate getBaudRate();
  public BSerialDataBits getDataBits();
  public BSerialStopBits getStopBits();
  public BSerialParity   getParity();

  public void setSerialPortParams(BBaudRate baudrate,
                             BSerialDataBits dataBits,
                             BSerialStopBits stopBits,
                             BSerialParity parity) throws UnsupportedOperationException;

  public void setDTR(boolean dtr);
  public boolean isDTR();
  public void setRTS(boolean rts);
  public boolean isRTS();
  public boolean isCTS();
  public boolean isDSR();
  public boolean isRI();
  public boolean isCD();

  public void enableReceiveThreshold(int threshold) throws UnsupportedOperationException;
  public void disableReceiveThreshold();
  public boolean isReceiveThresholdEnabled();
  public int getReceiveThreshold() throws UnsupportedOperationException;

  public void enableReceiveTimeout(int timeout) throws UnsupportedOperationException;
  public void disableReceiveTimeout();
  public boolean isReceiveTimeoutEnabled();
  public int getReceiveTimeout() throws UnsupportedOperationException;

  public InputStream getInputStream() throws IOException;
  public OutputStream getOutputStream() throws IOException;

  public static final Type TYPE = Sys.loadType(BISerialPort.class);

}