/*
 * Copyright 2001 Tridium, Inc.  All rights reserved.
 */

package javax.baja.schedule;

import javax.baja.sys.BMonth;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/**
 * @author Aaron Hansen
 * @version $Revision: 15$ $Date: 1/9/08 10:47:58 AM EST$
 * @creation Oct 2002
 */
public class BWeekAndDaySchedule
    extends BCompositeSchedule
    //implements
{

  /////////////////////////////////////////////////////////////////
  // Properties
  /////////////////////////////////////////////////////////////////

  public static final Property union = newProperty(Flags.USER_DEFINED_1 | Flags.READONLY, false, null);

  /*-
  class BWeekAndDaySchedule
  {
    properties
    {
      months: BMonthSchedule
        default {[new BMonthSchedule().initEffectiveWhenEmpty(true).initSingleSelection(true)]}
      weeksOfMonth: BWeekOfMonthSchedule
        default {[new BWeekOfMonthSchedule().initEffectiveWhenEmpty(true).initSingleSelection(true)]}
      weekdays: BWeekdaySchedule
        default {[new BWeekdaySchedule().initEffectiveWhenEmpty(true).initSingleSelection(true)]}
    }
    actions
    {
    }
    topics
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.schedule.BWeekAndDaySchedule(4250009142)1.0$ @*/
/* Generated Tue Sep 07 10:10:17 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "months"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code months} property.
   *
   * @see javax.baja.schedule.BWeekAndDaySchedule#getMonths
   * @see javax.baja.schedule.BWeekAndDaySchedule#setMonths
   */
  public static final Property months = newProperty(0, new BMonthSchedule().initEffectiveWhenEmpty(true).initSingleSelection(true), null);

  /**
   * Get the {@code months} property.
   *
   * @see javax.baja.schedule.BWeekAndDaySchedule#months
   */
  public BMonthSchedule getMonths()
  {
    return (BMonthSchedule)get(months);
  }

  /**
   * Set the {@code months} property.
   *
   * @see javax.baja.schedule.BWeekAndDaySchedule#months
   */
  public void setMonths(BMonthSchedule v)
  {
    set(months, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "weeksOfMonth"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code weeksOfMonth} property.
   *
   * @see javax.baja.schedule.BWeekAndDaySchedule#getWeeksOfMonth
   * @see javax.baja.schedule.BWeekAndDaySchedule#setWeeksOfMonth
   */
  public static final Property weeksOfMonth = newProperty(0, new BWeekOfMonthSchedule().initEffectiveWhenEmpty(true).initSingleSelection(true), null);

  /**
   * Get the {@code weeksOfMonth} property.
   *
   * @see javax.baja.schedule.BWeekAndDaySchedule#weeksOfMonth
   */
  public BWeekOfMonthSchedule getWeeksOfMonth()
  {
    return (BWeekOfMonthSchedule)get(weeksOfMonth);
  }

  /**
   * Set the {@code weeksOfMonth} property.
   *
   * @see javax.baja.schedule.BWeekAndDaySchedule#weeksOfMonth
   */
  public void setWeeksOfMonth(BWeekOfMonthSchedule v)
  {
    set(weeksOfMonth, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "weekdays"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code weekdays} property.
   *
   * @see javax.baja.schedule.BWeekAndDaySchedule#getWeekdays
   * @see javax.baja.schedule.BWeekAndDaySchedule#setWeekdays
   */
  public static final Property weekdays = newProperty(0, new BWeekdaySchedule().initEffectiveWhenEmpty(true).initSingleSelection(true), null);

  /**
   * Get the {@code weekdays} property.
   *
   * @see javax.baja.schedule.BWeekAndDaySchedule#weekdays
   */
  public BWeekdaySchedule getWeekdays()
  {
    return (BWeekdaySchedule)get(weekdays);
  }

  /**
   * Set the {@code weekdays} property.
   *
   * @see javax.baja.schedule.BWeekAndDaySchedule#weekdays
   */
  public void setWeekdays(BWeekdaySchedule v)
  {
    set(weekdays, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BWeekAndDaySchedule.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /////////////////////////////////////////////////////////////////
  // Constructors
  /////////////////////////////////////////////////////////////////

  public BWeekAndDaySchedule()
  {
  }


  /////////////////////////////////////////////////////////////////
  // Methods - Public and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  /**
   * -1 if always effective, otherwise the month ordinal.
   */
  public int getMonth()
  {
    return getField(getMonths());
  }

  public int getWeek()
  {
    return getField(getWeeksOfMonth());
  }

  public int getWeekday()
  {
    return getField(getWeekdays());
  }

  public void setMonth(int val)
  {
    getMonths().clear();
    if (val == -1)
      getMonths().setAlwaysEffective(true);
    else
    {
      getWeekdays().setAlwaysEffective(false);
      getMonths().add(val);
    }
  }

  public void setWeek(int val)
  {
    getWeeksOfMonth().clear();
    if (val == -1)
      getWeeksOfMonth().setAlwaysEffective(true);
    else
    {
      getWeekdays().setAlwaysEffective(false);
      getWeeksOfMonth().add(val);
    }
  }

  public void setWeekday(int val)
  {
    getWeekdays().clear();
    if (val == -1)
      getWeekdays().setAlwaysEffective(true);
    else
    {
      getWeekdays().setAlwaysEffective(false);
      getWeekdays().add(val);
    }
  }

  @Override
  public String toString(Context cx)
  {
    Lexicon l = Lexicon.make(BAbstractSchedule.class);
    boolean criteria = false;
    StringBuffer buf = new StringBuffer(l.get("type.weekAndDaySchedule"));
    buf.append(": ");
    //weekday
    int i = getWeekday();
    if (i >= 0)
    {
      BWeekday w = BWeekday.make(i);
      buf.append(w.getShortDisplayTag(cx));
      criteria = true;
    }
    //week
    i = getWeek();
    if (i >= 0)
    {
      if (criteria)
        buf.append(' ');
      if (i == 6)
        buf.append(l.get("week.last7days"));
      else if (i < 6)
        buf.append(l.get("week.week")).append(' ').append(i);
      else
        buf.append(l.get("week.calendarWeek")).append(' ').append(i - 6);
      criteria = true;
    }
    else if (criteria)
    {
      buf.append(' ').append(l.get("week.everyWeek"));
    }
    //month
    i = getMonth();
    if (i >= 0)
    {
      if (criteria)
        buf.append(' ');
      if (i == 12)
      {
        buf.append(l.get("month.jan_mar_may_jul_sep_nov"));
      }
      else if (i == 13)
      {
        buf.append(l.get("month.feb_apr_jun_aug_oct_dec"));
      }
      else
      {
        BMonth m = BMonth.make(i);
        buf.append(m.getShortDisplayTag(cx));
      }
      criteria = true;
    }
    else if (criteria)
    {
      buf.append(' ').append(l.get("month.everyMonth"));
    }
    if (!criteria)
      buf.append("*");
    return buf.toString();
  }

  /////////////////////////////////////////////////////////////////
  // Methods - Protected and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  protected int getField(BEnumSetSchedule sch)
  {
    if (getAlwaysEffective())
      return -1;
    if (sch.isAlwaysEffective())
      return -1;
    return sch.first();
  }


  /////////////////////////////////////////////////////////////////
  // Inner Classes - in alphabetical order by class name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Constants - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Attributes - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Initialization
  /////////////////////////////////////////////////////////////////


}//BWeekAndDaySchedule
