/*
 * Copyright 2002 Tridium, Inc.  All rights reserved.
 */

package javax.baja.schedule;

import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/**
 * @author Aaron Hansen
 * @creation Oct 2002
 * @version $Revision: 12$ $Date: 9/10/04 4:06:17 PM EDT$
 */
public class BDateRangeSchedule
  extends BAbstractSchedule
  //implements
{

  /////////////////////////////////////////////////////////////////
  // Properties
  /////////////////////////////////////////////////////////////////

  /*-
  class BDateRangeSchedule
  {
    properties
    {
      start : BDateSchedule
        default {[new BDateSchedule()]}
      end : BDateSchedule
        default {[new BDateSchedule()]}
    }
    actions
    {
    }
    topics
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.schedule.BDateRangeSchedule(3399813110)1.0$ @*/
/* Generated Tue Oct 29 10:10:38 EST 2002 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "start"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code start} property.
   * @see javax.baja.schedule.BDateRangeSchedule#getStart
   * @see javax.baja.schedule.BDateRangeSchedule#setStart
   */
  public static final Property start = newProperty(0, new BDateSchedule(),null);

  /**
   * Get the {@code start} property.
   * @see javax.baja.schedule.BDateRangeSchedule#start
   */
  public BDateSchedule getStart() { return (BDateSchedule)get(start); }

  /**
   * Set the {@code start} property.
   * @see javax.baja.schedule.BDateRangeSchedule#start
   */
  public void setStart(BDateSchedule v) { set(start,v,null); }

////////////////////////////////////////////////////////////////
// Property "end"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code end} property.
   * @see javax.baja.schedule.BDateRangeSchedule#getEnd
   * @see javax.baja.schedule.BDateRangeSchedule#setEnd
   */
  public static final Property end = newProperty(0, new BDateSchedule(),null);

  /**
   * Get the {@code end} property.
   * @see javax.baja.schedule.BDateRangeSchedule#end
   */
  public BDateSchedule getEnd() { return (BDateSchedule)get(end); }

  /**
   * Set the {@code end} property.
   * @see javax.baja.schedule.BDateRangeSchedule#end
   */
  public void setEnd(BDateSchedule v) { set(end,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDateRangeSchedule.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /////////////////////////////////////////////////////////////////
  // Constructors
  /////////////////////////////////////////////////////////////////

  public BDateRangeSchedule() {}


  /////////////////////////////////////////////////////////////////
  // Methods - Public and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  @Override
  public boolean isEffective(BAbsTime arg)
  {
    if (getAlwaysEffective()) return true;
    BDateSchedule str = getStart();
    BDateSchedule end = getEnd();
    int strTo = str.compareTo(arg);
    int endTo = end.compareTo(arg);
    int tmp = str.getYear();
    int argYear = arg.getYear();
    if ((tmp >= 0) && (tmp > argYear))
      return false;
    tmp = end.getYear();
    if ((tmp >= 0) && (tmp < argYear))
      return false;
    if (str.compareTo(end) <= 0)
      return (strTo <= 0) && (endTo >= 0);
    return (strTo <= 0) || (endTo >= 0);
  }

  @Override
  public BAbsTime nextEvent(BAbsTime t)
  {
    BAbsTime startNext = getStart().nextEvent(t);
    BAbsTime endNext = getEnd().nextEvent(t);
    if (startNext == null)
      return endNext;
    else if (endNext == null)
      return startNext;
    else if (startNext.isBefore(endNext))
      return startNext;
    else
      return endNext;
  }

  @Override
  public String toString(Context cx)
  {
    String s = getStart().criteriaString(cx);
    String e = getEnd().criteriaString(cx);
    Lexicon l = Lexicon.make(BAbstractSchedule.class);
    return l.get("type.dateRangeSchedule") + ": " + s + " - " + e;
  }


  /////////////////////////////////////////////////////////////////
  // Methods - Protected and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Methods - Private and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Inner Classes - in alphabetical order by class name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Constants - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Attributes - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Initialization
  /////////////////////////////////////////////////////////////////


}//BDateRangeSchedule
