/*
 * Copyright 2001 Tridium, Inc.  All rights reserved.
 */

package javax.baja.schedule;

import javax.baja.status.*;
import javax.baja.sys.*;

/**
 * Schedule combining a day schedule with another for determining when
 * to apply the day.
 * @author Aaron Hansen
 * @creation Aug 2002
 * @version $Revision: 20$ $Date: 7/17/09 10:08:35 AM EDT$
 */
public class BDailySchedule
  extends BCompositeSchedule
  //implements
{

  /////////////////////////////////////////////////////////////////
  // Properties
  /////////////////////////////////////////////////////////////////

  public static final Property union = newProperty(Flags.USER_DEFINED_1 | Flags.READONLY, false,null);

  /*-
  class BDailySchedule
  {
    properties
    {
      day: BDaySchedule
        flags {readonly}
        default {[new BDaySchedule()]}
      days: BAbstractSchedule
        default {[new BDateSchedule()]}
    }
    actions
    {
    }
    topics
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.schedule.BDailySchedule(1676274325)1.0$ @*/
/* Generated Fri Sep 10 15:28:16 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "day"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code day} property.
   * @see javax.baja.schedule.BDailySchedule#getDay
   * @see javax.baja.schedule.BDailySchedule#setDay
   */
  public static final Property day = newProperty(Flags.READONLY, new BDaySchedule(),null);

  /**
   * Get the {@code day} property.
   * @see javax.baja.schedule.BDailySchedule#day
   */
  public BDaySchedule getDay() { return (BDaySchedule)get(day); }

  /**
   * Set the {@code day} property.
   * @see javax.baja.schedule.BDailySchedule#day
   */
  public void setDay(BDaySchedule v) { set(day,v,null); }

////////////////////////////////////////////////////////////////
// Property "days"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code days} property.
   * @see javax.baja.schedule.BDailySchedule#getDays
   * @see javax.baja.schedule.BDailySchedule#setDays
   */
  public static final Property days = newProperty(0, new BDateSchedule(),null);

  /**
   * Get the {@code days} property.
   * @see javax.baja.schedule.BDailySchedule#days
   */
  public BAbstractSchedule getDays() { return (BAbstractSchedule)get(days); }

  /**
   * Set the {@code days} property.
   * @see javax.baja.schedule.BDailySchedule#days
   */
  public void setDays(BAbstractSchedule v) { set(days,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDailySchedule.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /////////////////////////////////////////////////////////////////
  // Constructors
  /////////////////////////////////////////////////////////////////

  public BDailySchedule() {}

  public BDailySchedule(BAbstractSchedule sch)
  {
    setDays(sch);
  }

  public BDailySchedule(BAbstractSchedule sch,
                        BTime start,
                        BTime finish,
                        BStatusValue value)
  {
    setDays(sch);
    add(start,finish,value);
  }


  /////////////////////////////////////////////////////////////////
  // Methods - Public and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  public boolean add(BTime start, BTime finish, BStatusValue value)
  {
    return add(start,finish,value, null);
  }

  public boolean add(BTime start, BTime finish, BStatusValue value, Context cx)
  {
    return getDay().add(start,finish,value, cx);
  }

  @Override
  public BAbsTime nextEvent(BAbsTime after)
  {
    if (getDay().nextEvent(after) == null)
      return null;
    if (getDays().isEffective(after))
      return super.nextEvent(after);
    return getDays().nextEvent(after);
  }

  @Override
  public String toString(Context cx)
  {
    return getDays().toString(cx);
  }

  /////////////////////////////////////////////////////////////////
  // Methods - Protected and in alphabetical order by method name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Inner Classes - in alphabetical order by class name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Constants - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Attributes - in alphabetical order by field name.
  /////////////////////////////////////////////////////////////////

  /////////////////////////////////////////////////////////////////
  // Initialization
  /////////////////////////////////////////////////////////////////


}//BDailySchedule
