/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.report;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/**
 * BReportSource is responsible for generating BReports for consumption
 * by BReportRecipients.  Reports are generated when the {@code generate}
 * action is invoked. ReportSource includes a built-in schedule for
 * automatically invoking {@code generate} on a scheduled basis.
 * Subclasses should override {@code handleGenerate()} to customize:
 *
 * <pre>{@code
 *   public class BMyReportSource
 *     extends BReportSource
 *   {
 *     public BReport handleGenerate()
 *       throws Exception
 *     {
 *       ...
 *       return new BReport(...);
 *     }
 *   }
 * }</pre>
 *
 * @author    Andy Frank
 * @creation  16 Oct 06
 * @version   $Revision: 6$ $Date: 11/28/07 3:39:18 PM EST$
 * @since     Niagara 3.2
 */
public abstract class BReportSource
  extends BComponent
{
  /*-
  class BReportSource
  {
    properties
    {
      schedule: BTimeTrigger
        -- The schedule used to trigger this report to be generated.
        default {[ new BTimeTrigger() ]}
    }

    actions
    {
      generate()
        -- Generate this report and fire the out topic.
        flags { async }
    }

    topics
    {
      out: BReport
       -- Fired when generate() is invoked.
       flags { readonly, summary }
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.report.BReportSource(3354990634)1.0$ @*/
/* Generated Wed Nov 28 11:17:30 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "schedule"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code schedule} property.
   * The schedule used to trigger this report to be generated.
   * @see javax.baja.report.BReportSource#getSchedule
   * @see javax.baja.report.BReportSource#setSchedule
   */
  public static final Property schedule = newProperty(0, new BTimeTrigger(),null);

  /**
   * Get the {@code schedule} property.
   * @see javax.baja.report.BReportSource#schedule
   */
  public BTimeTrigger getSchedule() { return (BTimeTrigger)get(schedule); }

  /**
   * Set the {@code schedule} property.
   * @see javax.baja.report.BReportSource#schedule
   */
  public void setSchedule(BTimeTrigger v) { set(schedule,v,null); }

////////////////////////////////////////////////////////////////
// Action "generate"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code generate} action.
   * Generate this report and fire the out topic.
   * @see javax.baja.report.BReportSource#generate()
   */
  public static final Action generate = newAction(Flags.ASYNC,null);

  /**
   * Invoke the {@code generate} action.
   * @see javax.baja.report.BReportSource#generate
   */
  public void generate() { invoke(generate,null,null); }

////////////////////////////////////////////////////////////////
// Topic "out"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code out} topic.
   * Fired when generate() is invoked.
   * @see javax.baja.report.BReportSource#fireOut
   */
  public static final Topic out = newTopic(Flags.READONLY|Flags.SUMMARY,null);

  /**
   * Fire an event for the {@code out} topic.
   * @see javax.baja.report.BReportSource#out
   */
  public void fireOut(BReport event) { fire(out, event, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BReportSource.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

  @Override
  public void started()
  {
    linkTo(getSchedule(), BTimeTrigger.fireTrigger, generate);
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Generate a new Report.
   */
  public abstract BReport handleGenerate() throws Exception;

////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

  public final void doGenerate()
  {
    try
    {
      BReport event = handleGenerate();
      fireOut(event);
    }
    catch (Exception e)
    {
      log.log(Level.SEVERE, "Generate failed", e);
      throw new BajaRuntimeException(e);
    }
  }

  @Override
  public IFuture post(Action action, BValue arg, Context cx)
  {
    if (action == generate)
    {
      BReportService s = (BReportService)Sys.getService(BReportService.TYPE);
      s.enqueue(new Invocation(this, action, arg, cx));
      return null;
    }
    else
    {
      return super.post(action, arg, cx);
    }
  }

////////////////////////////////////////////////////////////////
// BObject
////////////////////////////////////////////////////////////////

  /**
   * Get the icon.
   */
  @Override
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("export.png");

////////////////////////////////////////////////////////////////
//  Attributes
////////////////////////////////////////////////////////////////

  public static final Logger log = Logger.getLogger("report");

}

