/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.report;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Flags;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BReportRecipient consumes a Report generated from a ReportSource.
 * Typically this class will route the report object to some recipient,
 * such as emailing someone the report file as an attachment. Subclasses
 * should override {@code handleReport()} to customize:
 *
 * {@code <pre>
 *   public class BMyReportRecipient
 *     extends BReportRecipient
 *   {
 *     public void handleRoute(BReport event)
 *       throws Exception
 *     {
 *       ...
 *     }
 *   }
 * </pre>}
 *
 * @author    Andy Frank
 * @creation  16 Oct 06
 * @version   $Revision: 3$ $Date: 11/3/06 4:39:01 PM EST$
 * @since     Niagara 3.2
 */
public abstract class BReportRecipient
  extends BComponent
{
  /*-
  class BReportRecipient
  {
    actions
    {
      route(report: BReport)
       -- Route a report event.
       flags { summary }
       default {[ new BReport() ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.report.BReportRecipient(763604023)1.0$ @*/
/* Generated Fri Nov 03 11:28:23 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Action "route"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the {@code route} action.
   * Route a report event.
   * @see javax.baja.report.BReportRecipient#route()
   */
  public static final Action route = newAction(Flags.SUMMARY,new BReport(),null);

  /**
   * Invoke the {@code route} action.
   * @see javax.baja.report.BReportRecipient#route
   */
  public void route(BReport report) { invoke(route,report,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BReportRecipient.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Handle the ReportRecipient specific routing of the report.
   */
  public abstract void handleRoute(BReport event) throws Exception;

////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

  public final void doRoute(BReport event)
  {
    try
    {
      handleRoute(event);
    }
    catch (Exception e)
    {
      log.log(Level.SEVERE, "Route failed", e);
      throw new BajaRuntimeException(e);
    }
  }

////////////////////////////////////////////////////////////////
// BObject
////////////////////////////////////////////////////////////////

  /**
   * Get the icon.
   */
  @Override
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("export.png");

////////////////////////////////////////////////////////////////
//  Attributes
////////////////////////////////////////////////////////////////

  public static final Logger log = Logger.getLogger("report");

}

