/**
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.rdb.history;

import javax.baja.sys.*;

/**
 * BRdbmsHistoryExportMode defines whether histories will
 * be exported into one table per history, or one table
 * per BHistoryRecord type.
 * 
 * @author    Mike Jarmy
 * @creation  28 Feb 07
 * @version   $Revision: 1$ $Date: 3/22/07 11:16:16 AM EDT$  
 * @since     Niagara 3.1     
 */
public final class BRdbmsHistoryExportMode
  extends BFrozenEnum  
{
  /*-
  enum BRdbmsHistoryExportMode
  {
    range
    {
      byHistoryId,
      byHistoryType,
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.rdb.history.BRdbmsHistoryExportMode(253992499)1.0$ @*/
/* Generated Tue Jul 10 12:21:46 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for byHistoryId. */
  public static final int BY_HISTORY_ID = 0;
  /** Ordinal value for byHistoryType. */
  public static final int BY_HISTORY_TYPE = 1;
  
  /** BRdbmsHistoryExportMode constant for byHistoryId. */
  public static final BRdbmsHistoryExportMode byHistoryId = new BRdbmsHistoryExportMode(BY_HISTORY_ID);
  /** BRdbmsHistoryExportMode constant for byHistoryType. */
  public static final BRdbmsHistoryExportMode byHistoryType = new BRdbmsHistoryExportMode(BY_HISTORY_TYPE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRdbmsHistoryExportMode.class);
  
  /** Factory method with ordinal. */
  public static BRdbmsHistoryExportMode make(int ordinal)
  {
    return (BRdbmsHistoryExportMode)byHistoryId.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BRdbmsHistoryExportMode make(String tag)
  {
    return (BRdbmsHistoryExportMode)byHistoryId.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BRdbmsHistoryExportMode(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BRdbmsHistoryExportMode DEFAULT = BRdbmsHistoryExportMode.byHistoryId;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
 

}
