/**
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.rdb.history;

import javax.baja.sys.*;
import javax.baja.naming.*;

/**
 * BRdbmsColumnSelection is used to specify a relational database column.
 * This is useful when mapping rdb table columns to history columns during
 * the import process.  
 *
 * @author    Scott Hoye
 * @creation  12 Apr 06
 * @version   $Revision: 4$ $Date: 3/19/07 1:17:42 PM EDT$  
 * @since     Baja 3.1     
 */
public class BRdbmsColumnSelection
  extends BStruct
{
  /*-
  
  class BRdbmsColumnSelection
  {
    properties
    {
      column : BDynamicEnum
        -- The rdb table column (list of Strings)
        default {[ BDynamicEnum.DEFAULT ]}
    }
  }
 
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.rdb.history.BRdbmsColumnSelection(3892379765)1.0$ @*/
/* Generated Wed Feb 28 09:29:08 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "column"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>column</code> property.
   * The rdb table column (list of Strings)
   * @see javax.baja.rdb.history.BRdbmsColumnSelection#getColumn
   * @see javax.baja.rdb.history.BRdbmsColumnSelection#setColumn
   */
  public static final Property column = newProperty(0, BDynamicEnum.DEFAULT,null);
  
  /**
   * Get the <code>column</code> property.
   * @see javax.baja.rdb.history.BRdbmsColumnSelection#column
   */
  public BDynamicEnum getColumn() { return (BDynamicEnum)get(column); }
  
  /**
   * Set the <code>column</code> property.
   * @see javax.baja.rdb.history.BRdbmsColumnSelection#column
   */
  public void setColumn(BDynamicEnum v) { set(column,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRdbmsColumnSelection.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public String toString(Context cx)
  {
    return SlotPath.unescape(getColumn().getTag());
  }
  
  public boolean equivalent(Object obj)
  {
    if (obj instanceof BRdbmsColumnSelection)
    {
      return getColumn().getRange().equals(((BRdbmsColumnSelection)obj).getColumn().getRange());
    }
    return false;
  }

}

