/*
 * Copyright 2005, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.rdb.ddl;

import javax.baja.sys.*;

/**
 * BClustered defines whether something is clustered, nonclustered, or unspecified.
 * 
 * @author    Mike Jarmy
 * @creation  06 Mar 10
 * @version   $Revision$ $Date: 8/4/2005 4:53:55 PM$
 * @since     Baja 1.0
 */
public final class BClustered
  extends BFrozenEnum
{
  /*-
  
  enum BClustered
  {
    range
    {
      unspecified,
      clustered,
      nonClustered,
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.rdb.ddl.BClustered(2780390906)1.0$ @*/
/* Generated Tue Jul 10 12:22:50 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for unspecified. */
  public static final int UNSPECIFIED = 0;
  /** Ordinal value for clustered. */
  public static final int CLUSTERED = 1;
  /** Ordinal value for nonClustered. */
  public static final int NON_CLUSTERED = 2;
  
  /** BClustered constant for unspecified. */
  public static final BClustered unspecified = new BClustered(UNSPECIFIED);
  /** BClustered constant for clustered. */
  public static final BClustered clustered = new BClustered(CLUSTERED);
  /** BClustered constant for nonClustered. */
  public static final BClustered nonClustered = new BClustered(NON_CLUSTERED);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BClustered.class);
  
  /** Factory method with ordinal. */
  public static BClustered make(int ordinal)
  {
    return (BClustered)unspecified.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BClustered make(String tag)
  {
    return (BClustered)unspecified.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BClustered(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BClustered DEFAULT = BClustered.unspecified;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
}
