/**
 * Copyright 2012 - All Rights Reserved.
 */
package com.tridium.nvideo.ui;

import com.tridium.ndriver.ui.point.BNPointManager;
import com.tridium.ndriver.ui.point.NPointModel;

import javax.baja.control.BBooleanPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

/**
 * BVideoEventManager is a customized BNPointManager for video event proxies.
 *
 * @author   Robert Adams
 * @creation Oct 31, 2012
 */
public class BVideoEventManager
    extends BNPointManager
{
  /*-
   class BVideoEventManager
   {
     properties
     {
     }
     actions
     {
     }
     topics
     {
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nvideo.ui.BVideoEventManager(1791598309)1.0$ @*/
/* Generated Wed Oct 31 10:57:11 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BVideoEventManager.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  /** Empty constructor   */
  public BVideoEventManager() {  }
  
  /** Custom mgrModel to limit point types */
  protected MgrModel makeModel() {  return new EventMgrModel(this);  }

////////////////////////////////////////////////////////////////
// Custom mgrModel
////////////////////////////////////////////////////////////////
  class EventMgrModel
    extends NPointModel
  {
    public EventMgrModel(BNPointManager manager)
    {
      super(manager);
    }

    public MgrTypeInfo[] getNewTypes()
    {
      return VALID_DB_TYPES;
    }                          
    
  }
  
////////////////////////////////////////////////////////////////
// Statics
////////////////////////////////////////////////////////////////
  public static final MgrTypeInfo[] VALID_DB_TYPES =
      MgrTypeInfo.makeArray(
             new TypeInfo[] {  BBooleanPoint.TYPE.getTypeInfo(), 
                               BStringPoint.TYPE.getTypeInfo(),
                               BNumericPoint.TYPE.getTypeInfo()  }
                           );
  
}
