/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio.points;

import javax.baja.control.BNumericPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.components.BINrioIoStatus;
import com.tridium.nrio.components.BNrio16Status;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
/**
 * @author    Bill Smith
 * @creation  3 Feb 2004
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

public class BNrioResistiveInputProxyExt extends BUiProxyExt
{ 

  public static final Property uiType = newProperty(Flags.READONLY, BUniversalInputTypeEnum.ai_Resistive, null);  
  public static final Property deviceFacets = newProperty(Flags.READONLY,BFacets.makeInt(UnitDatabase.getUnit("ohm")));

  /*-
  
  class BNrioResistiveInputProxyExt
  {
    properties
    {      
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.points.BNrioResistiveInputProxyExt(1650672232)1.0$ @*/
/* Generated Sat Aug 04 16:15:15 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNrioResistiveInputProxyExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Callbacks
////////////////////////////////////////////////////////////////  

  public boolean isParentLegal(BComponent parent)
  {
    if (super.isParentLegal(parent))
      if (parent instanceof BNumericPoint)
        return true;

    return false;
  }

  public BReadWriteMode getMode()
  {
    return BReadWriteMode.readonly;
  }

  public void ioValueChanged()
  {
    BINrioIoStatus ioStatus = (BINrioIoStatus)((BNrio16Module)getDevice()).getIoStatus();
    int maxUiInstance = ioStatus.getMaxUiInstance();
    if(getUiType().getOrdinal() != BUniversalInputTypeEnum.AI_RESISTIVE  || getInstance() < 1 || getInstance() > maxUiInstance)
      {
    	readFail("readFail.invalidInstanceOrData");
      }
      else
      {
    	try 
    	{
          float value = (float) ioStatus.getAi(getInstance());
          if (value < 4095f)
          {
            value = (value * 10000f / (4095f - value));
          if (value < 0f)
        	value = 0f;
          if (value > 100000f)
        	value = 100000f;
          }
          else
            value = 100000f;
          BStatusNumeric svalue = new BStatusNumeric(value);
          readOk(svalue);
    	}
    	catch(Exception e)
    	{
    	  readFail(e.getMessage());
    	}
      }
  }
  
////////////////////////////////////////////////////////////////
// Abstract
////////////////////////////////////////////////////////////////  

////////////////////////////////////////////////////////////////
// Implementation
////////////////////////////////////////////////////////////////    

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

}
