/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio.points;

import javax.baja.control.BNumericPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrio34Module;
import com.tridium.nrio.components.BINrioIoStatus;
import com.tridium.nrio.components.BNrio16Status;
import com.tridium.nrio.enums.BNrio16CounterSelectEnum;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
import com.tridium.nrio.types.BAbstractRateType;
import com.tridium.nrio.types.BFixedWindowRateType;

/**
 * @author    Bill Smith
 * @creation  3 Feb 2004
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

public class BNrioCounterInputProxyExt extends BUiProxyExt
{ 

  public static final Property uiType = newProperty(Flags.READONLY, BUniversalInputTypeEnum.di_HighSpeed, null);  

  /*-
  
  class BNrioCounterInputProxyExt
  {
    properties
    {
      outputSelect: BNrio16CounterSelectEnum
        default{[ BNrio16CounterSelectEnum.count ]}

      total: long
        flags { readonly }
        default {[ -1 ]}
        
      rate: double
        flags { readonly, transient }
        default {[ 0 ]}

      rateCalcType: BTypeSpec
        default {[ BTypeSpec.make("nrio:FixedWindowRateType") ]}
        slotfacets {[ BFacets.make(BFacets.TARGET_TYPE, BString.make("nrio:AbstractRateType")) ]}
        
      rateCalc: BAbstractRateType
        flags { readonly }
        default {[ new BFixedWindowRateType() ]}
        
      rateCalcTime: BAbsTime
        flags {readonly, transient }
        default {[ BAbsTime.DEFAULT ]}
    }
    actions
    {
      reset()

      set(param: BLong)
        default {[ BLong.make(0) ]}

      recalculateRate()
        flags { hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.points.BNrioCounterInputProxyExt(2272935113)1.0$ @*/
/* Generated Mon Feb 15 09:48:11 EST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "outputSelect"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outputSelect</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#getOutputSelect
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#setOutputSelect
   */
  public static final Property outputSelect = newProperty(0, BNrio16CounterSelectEnum.count,null);
  
  /**
   * Get the <code>outputSelect</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#outputSelect
   */
  public BNrio16CounterSelectEnum getOutputSelect() { return (BNrio16CounterSelectEnum)get(outputSelect); }
  
  /**
   * Set the <code>outputSelect</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#outputSelect
   */
  public void setOutputSelect(BNrio16CounterSelectEnum v) { set(outputSelect,v,null); }

////////////////////////////////////////////////////////////////
// Property "total"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>total</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#getTotal
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#setTotal
   */
  public static final Property total = newProperty(Flags.READONLY, -1,null);
  
  /**
   * Get the <code>total</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#total
   */
  public long getTotal() { return getLong(total); }
  
  /**
   * Set the <code>total</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#total
   */
  public void setTotal(long v) { setLong(total,v,null); }

////////////////////////////////////////////////////////////////
// Property "rate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rate</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#getRate
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#setRate
   */
  public static final Property rate = newProperty(Flags.READONLY|Flags.TRANSIENT, 0,null);
  
  /**
   * Get the <code>rate</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#rate
   */
  public double getRate() { return getDouble(rate); }
  
  /**
   * Set the <code>rate</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#rate
   */
  public void setRate(double v) { setDouble(rate,v,null); }

////////////////////////////////////////////////////////////////
// Property "rateCalcType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rateCalcType</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#getRateCalcType
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#setRateCalcType
   */
  public static final Property rateCalcType = newProperty(0, BTypeSpec.make("nrio:FixedWindowRateType"),BFacets.make(BFacets.TARGET_TYPE, BString.make("nrio:AbstractRateType")));
  
  /**
   * Get the <code>rateCalcType</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#rateCalcType
   */
  public BTypeSpec getRateCalcType() { return (BTypeSpec)get(rateCalcType); }
  
  /**
   * Set the <code>rateCalcType</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#rateCalcType
   */
  public void setRateCalcType(BTypeSpec v) { set(rateCalcType,v,null); }

////////////////////////////////////////////////////////////////
// Property "rateCalc"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rateCalc</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#getRateCalc
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#setRateCalc
   */
  public static final Property rateCalc = newProperty(Flags.READONLY, new BFixedWindowRateType(),null);
  
  /**
   * Get the <code>rateCalc</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#rateCalc
   */
  public BAbstractRateType getRateCalc() { return (BAbstractRateType)get(rateCalc); }
  
  /**
   * Set the <code>rateCalc</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#rateCalc
   */
  public void setRateCalc(BAbstractRateType v) { set(rateCalc,v,null); }

////////////////////////////////////////////////////////////////
// Property "rateCalcTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rateCalcTime</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#getRateCalcTime
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#setRateCalcTime
   */
  public static final Property rateCalcTime = newProperty(Flags.READONLY|Flags.TRANSIENT, BAbsTime.DEFAULT,null);
  
  /**
   * Get the <code>rateCalcTime</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#rateCalcTime
   */
  public BAbsTime getRateCalcTime() { return (BAbsTime)get(rateCalcTime); }
  
  /**
   * Set the <code>rateCalcTime</code> property.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#rateCalcTime
   */
  public void setRateCalcTime(BAbsTime v) { set(rateCalcTime,v,null); }

////////////////////////////////////////////////////////////////
// Action "reset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>reset</code> action.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#reset()
   */
  public static final Action reset = newAction(0,null);
  
  /**
   * Invoke the <code>reset</code> action.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#reset
   */
  public void reset() { invoke(reset,null,null); }

////////////////////////////////////////////////////////////////
// Action "set"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>set</code> action.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#set()
   */
  public static final Action set = newAction(0,BLong.make(0),null);
  
  /**
   * Invoke the <code>set</code> action.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#set
   */
  public void set(BLong param) { invoke(set,param,null); }

////////////////////////////////////////////////////////////////
// Action "recalculateRate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>recalculateRate</code> action.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#recalculateRate()
   */
  public static final Action recalculateRate = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>recalculateRate</code> action.
   * @see com.tridium.nrio.points.BNrioCounterInputProxyExt#recalculateRate
   */
  public void recalculateRate() { invoke(recalculateRate,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNrioCounterInputProxyExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Callbacks
////////////////////////////////////////////////////////////////  

  public void started()
  throws Exception
  {
    super.started();
    if(isRunning())
    {
      if(getTotal() < 0)
        return;
      BNrio16Module device = (BNrio16Module)getDevice();
      // init ioStatus total count.
      int instance = getInstance();
      BINrioIoStatus ioStatus = (BINrioIoStatus)device.getIoStatus();
      if(device instanceof BNrio34Module)
      {
        if(instance > 8)
        {
          ioStatus = (BINrioIoStatus)((BNrio34Module)device).getIo34Sec().getIoStatus();
          instance = instance-8;
        }
      }
      ioStatus.setTotalCounts(instance, getTotal());
      doRecalculateRate();
    }    
  }

  
  public boolean isParentLegal(BComponent parent)
  {
    if (super.isParentLegal(parent))
      if (parent instanceof BNumericPoint)
        return true;

    return false;
  }

  public BReadWriteMode getMode()
  {
    return BReadWriteMode.readonly;
  }

  public void changed(Property prop, Context context)
  {
    super.changed(prop, context);
    
    if (isRunning()){
      if (prop.equals(rateCalcType)){
        BAbstractRateType type = (BAbstractRateType) getRateCalcType().getInstance();
        getRateCalc().cleanupType();
        setRateCalc(type);      
        getRateCalc().initType();
        setStale(true, null);  
      }
      
      else if (prop.equals(outputSelect))
      {
        setStale(true, null); 
      }
      
      else if(prop.equals(total))
      {
      	doRecalculateRate();
      }
    }
  }

//  public synchronized void read()
//  {
//    if (!pointSynchronized()) return;
//
//    try{
//      BStatusNumeric value = readNumericValue();
//      if (getOutputSelect() == BNrio16CounterSelectEnum.count)
//        readOk(value);        
//    }
//    catch(Exception e){
//      readFail(e.getMessage());
//    }      
//  }

  public void ioValueChanged()
  {
    BINrioIoStatus ioStatus = (BINrioIoStatus)((BNrio16Module)getDevice()).getIoStatus();
    int maxUiInstance = ioStatus.getMaxUiInstance();
    if(getUiType().getOrdinal() != BUniversalInputTypeEnum.DI_HIGH_SPEED  || getInstance() < 1 || getInstance() > maxUiInstance)
    {
      readFail("readFail.invalidInstanceOrData");
    }
    else
    {
      try
      {
        long value = ioStatus.getTotalCounts(getInstance());

        // if total hasn't changed force calculate rate to cause
        // stale flag to be cleared.
        if(value == getTotal())
          recalculateRate();
        else  // set total and changed will cause rate to be recalculated.
          setTotal(value);
      }
      catch(Exception e)
      {
        readFail(e.getMessage());
      }
    }
  }
  
  
////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////  
  
  public void doReset()
  {
    doSet(BLong.make(0));
  }
 
  public synchronized void doSet(BLong param)
  {
    long setValue = param.getLong();
    BNrio16Module device = (BNrio16Module)getDevice();
    BINrioIoStatus ioStatus = (BINrioIoStatus)device.getIoStatus();
    int instance = getInstance();
    if(device instanceof BNrio34Module)
    {
      if (instance > 8) // would have to be an IO34 Secondary device.
      {
        ioStatus = (BINrioIoStatus)((BNrio34Module)device).getIo34Sec().getIoStatus();
        instance = instance-8;
      }
    }
    ioStatus.setTotalCounts(instance, setValue);
    getRateCalc().resetRate();
    setTotal(setValue);
    
//    read();
  }  

  public void doRecalculateRate()
  {
//    if (!pointSynchronized()) return;

    try{
//      readNumericValue();
      BStatusNumeric value = getRateCalc().calculateRate(getTotal());
      if (value != null)
      {  
        setRate(value.getValue());     
        if (getOutputSelect() == BNrio16CounterSelectEnum.rate)
          readOk(value);
        else
        	readOk(new BStatusNumeric(getTotal()));
      }
      else
        if (getOutputSelect() == BNrio16CounterSelectEnum.rate)
          setStale(true, null);
    }
    catch(Exception e){
      readFail(e.getMessage());
    }      
  }
  
////////////////////////////////////////////////////////////////
// Abstract
////////////////////////////////////////////////////////////////  

////////////////////////////////////////////////////////////////
// Implementation
////////////////////////////////////////////////////////////////    

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
}
