/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio.points;

import javax.baja.control.BBooleanPoint;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.components.BINrioIoStatus;
import com.tridium.nrio.components.BNrio16Status;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
/**
 * A BNrioBooleanInputProxyExt is a point extention that
 * represents an boolean universal input.
 *
 * @author    Bill Smith
 * @creation  3 Feb 2004
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

public class BNrioBooleanInputProxyExt extends BUiProxyExt
{ 

  public static final Property uiType = newProperty(Flags.READONLY, BUniversalInputTypeEnum.di_Normal, null);  

  /*-
  
  class BNrioBooleanInputProxyExt
  {
    properties
    {      
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.points.BNrioBooleanInputProxyExt(3777402850)1.0$ @*/
/* Generated Sat Aug 04 16:15:15 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNrioBooleanInputProxyExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Callbacks
////////////////////////////////////////////////////////////////  

  /** 
   * Forces that this extension is on a boolean point.
   */

  public boolean isParentLegal(BComponent parent)
  {
    if (super.isParentLegal(parent))
      if (parent instanceof BBooleanPoint)
        return true;

    return false;
  }

  public BReadWriteMode getMode()
  {
    return BReadWriteMode.readonly;
  }


  public void ioValueChanged()
  {
    BINrioIoStatus ioStatus = (BINrioIoStatus)((BNrio16Module)getDevice()).getIoStatus();
    int maxUiInstance = ioStatus.getMaxUiInstance();
    if(getUiType().getOrdinal() != BUniversalInputTypeEnum.DI_NORMAL || getInstance() < 1 || getInstance() > maxUiInstance)
      {
    	readFail("readFail.invalidInstanceOrData");
      }
      else
      {
        BStatusBoolean sbValue = (BStatusBoolean)getReadValue().newCopy();
        sbValue.setValue(ioStatus.getDi(getInstance()));
        readOk(sbValue);
      }
  }
  
////////////////////////////////////////////////////////////////
// Abstract
////////////////////////////////////////////////////////////////  

////////////////////////////////////////////////////////////////
// Implementation
////////////////////////////////////////////////////////////////    

   
////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

}
