/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio.ext;

import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/**
 * The BNrioScaleOffsetExt is a standard point extension
 * that takes the value of a numeric point and applies
 * the linear function: newVal = oldVal * scale + offset
 *
 * @author    Bill Smith
 * @creation  1 Apr 2003
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BLinearCalibrationExt
  extends BPointExtension
{

  /*-

  class BLinearCalibrationExt
  {
    properties
    {
      scale: float
        --A multiplier against the old value
        default {[ 1.0f ]}
        slotfacets {[ BFacets.make(BFacets.PRECISION, BInteger.make(5)) ]}

      offset: float
        -- Added to the value after the scale
        -- has been applied.
        default {[ 0.0f ]}
        slotfacets {[ BFacets.make(BFacets.PRECISION, BInteger.make(5)) ]}

      units: BUnit
        default {[ BUnit.DEFAULT ]}

      faultCause: String
        flags { readonly, transient }
        default {[ "" ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.ext.BLinearCalibrationExt(3661165846)1.0$ @*/
/* Generated Thu Feb 14 10:05:08 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "scale"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>scale</code> property.
   * A multiplier against the old value
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#getScale
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#setScale
   */
  public static final Property scale = newProperty(0, 1.0f,BFacets.make(BFacets.PRECISION, BInteger.make(5)));
  
  /**
   * Get the <code>scale</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#scale
   */
  public float getScale() { return getFloat(scale); }
  
  /**
   * Set the <code>scale</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#scale
   */
  public void setScale(float v) { setFloat(scale,v,null); }

////////////////////////////////////////////////////////////////
// Property "offset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offset</code> property.
   * Added to the value after the scale has been applied.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#getOffset
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#setOffset
   */
  public static final Property offset = newProperty(0, 0.0f,BFacets.make(BFacets.PRECISION, BInteger.make(5)));
  
  /**
   * Get the <code>offset</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#offset
   */
  public float getOffset() { return getFloat(offset); }
  
  /**
   * Set the <code>offset</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#offset
   */
  public void setOffset(float v) { setFloat(offset,v,null); }

////////////////////////////////////////////////////////////////
// Property "units"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>units</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#getUnits
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#setUnits
   */
  public static final Property units = newProperty(0, BUnit.DEFAULT,null);
  
  /**
   * Get the <code>units</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#units
   */
  public BUnit getUnits() { return (BUnit)get(units); }
  
  /**
   * Set the <code>units</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#units
   */
  public void setUnits(BUnit v) { set(units,v,null); }

////////////////////////////////////////////////////////////////
// Property "faultCause"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>faultCause</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#getFaultCause
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#setFaultCause
   */
  public static final Property faultCause = newProperty(Flags.READONLY|Flags.TRANSIENT, "",null);
  
  /**
   * Get the <code>faultCause</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#faultCause
   */
  public String getFaultCause() { return getString(faultCause); }
  
  /**
   * Set the <code>faultCause</code> property.
   * @see com.tridium.nrio.ext.BLinearCalibrationExt#faultCause
   */
  public void setFaultCause(String v) { setString(faultCause,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLinearCalibrationExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
//  Constructors
////////////////////////////////////////////////////////////////

  public BLinearCalibrationExt()
  {
  }

  public BLinearCalibrationExt(BUnit units)
  {
    setUnits(units);
  }

////////////////////////////////////////////////////////////////
//  Parent checking
////////////////////////////////////////////////////////////////

  /**
   * Forces the parent to be a numeric point.
   */

  public boolean isParentLegal(BComponent parent)
  {
    if (parent instanceof BNumericPoint)
      return true;
    else
      return false;
  }


////////////////////////////////////////////////////////////////
//  Initialization
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
// Update Methods
////////////////////////////////////////////////////////////////

  public void changed(Property p, Context cx)
  {
  	super.changed(p, cx);
  	if(!isRunning())
  		return;
  	if(p.equals(scale) || p.equals(offset) || p.equals(units))
  	{
  		BControlPoint parent = getParentPoint();
  		if(parent != null) getParentPoint().execute();
  	}
  }

  /**
   * Called when either me or my parent control
   * point is updated.
   */

  public void onExecute(BStatusValue o, Context cx)
  {
    BStatusNumeric out = (BStatusNumeric)o;

    BUnit proxyUnit = (BUnit) getPointFacets().get(BFacets.UNITS, BUnit.NULL);

    if (proxyUnit.isConvertible(getUnits()))
    {
      double value = out.getValue();

      double calval = proxyUnit.convertTo(getUnits(), value);
      calval = getFloat(scale) * calval + getFloat(offset);
      value = getUnits().convertTo(proxyUnit, calval);

      o.setValueValue(BDouble.make(value));
      setFaultCause("");
    }
    else if (proxyUnit.isNull() || getUnits().isNull())
    {
      double value = out.getValue();
      value = getFloat(scale) * value + getFloat(offset);
      o.setValueValue(BDouble.make(value));
      setFaultCause("");
    }
    else
    {
      o.setStatusFault(true);
      setFaultCause("Units between point and extension are not convertible.");
    }
  }

////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

}