/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.nrio.components;

import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nrio.enums.BNrioIoTypeEnum;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BUiProxyExt;

/**
 * BUIPointEntry - The learn IO Module discovery job places instances of this component.
 * 
 *
 * @author    Andy Saunders
 * @creation  13 Jan 2005
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BUIPointEntry
  extends BComponent
{
  /*-
  class BUIPointEntry
  {
    properties
    {
      ioType : BNrioIoTypeEnum
        -- This is the unit number of the discovered access device
        default{[ BNrioIoTypeEnum.digitalInput]}
      uiType : BUniversalInputTypeEnum
        -- This selects specific input type if universal input
        default{[ BUniversalInputTypeEnum.undefined ]}
      instance : int
        -- This instance number for this IO
        default{[ 0 ]}
      usedByPoint: String
        default{[ "" ]} 
       
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.components.BUIPointEntry(776790142)1.0$ @*/
/* Generated Sat Aug 04 14:27:22 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "ioType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>ioType</code> property.
   * This is the unit number of the discovered access device
   * @see com.tridium.nrio.components.BUIPointEntry#getIoType
   * @see com.tridium.nrio.components.BUIPointEntry#setIoType
   */
  public static final Property ioType = newProperty(0, BNrioIoTypeEnum.digitalInput,null);
  
  /**
   * Get the <code>ioType</code> property.
   * @see com.tridium.nrio.components.BUIPointEntry#ioType
   */
  public BNrioIoTypeEnum getIoType() { return (BNrioIoTypeEnum)get(ioType); }
  
  /**
   * Set the <code>ioType</code> property.
   * @see com.tridium.nrio.components.BUIPointEntry#ioType
   */
  public void setIoType(BNrioIoTypeEnum v) { set(ioType,v,null); }

////////////////////////////////////////////////////////////////
// Property "uiType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>uiType</code> property.
   * This selects specific input type if universal input
   * @see com.tridium.nrio.components.BUIPointEntry#getUiType
   * @see com.tridium.nrio.components.BUIPointEntry#setUiType
   */
  public static final Property uiType = newProperty(0, BUniversalInputTypeEnum.undefined,null);
  
  /**
   * Get the <code>uiType</code> property.
   * @see com.tridium.nrio.components.BUIPointEntry#uiType
   */
  public BUniversalInputTypeEnum getUiType() { return (BUniversalInputTypeEnum)get(uiType); }
  
  /**
   * Set the <code>uiType</code> property.
   * @see com.tridium.nrio.components.BUIPointEntry#uiType
   */
  public void setUiType(BUniversalInputTypeEnum v) { set(uiType,v,null); }

////////////////////////////////////////////////////////////////
// Property "instance"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>instance</code> property.
   * This instance number for this IO
   * @see com.tridium.nrio.components.BUIPointEntry#getInstance
   * @see com.tridium.nrio.components.BUIPointEntry#setInstance
   */
  public static final Property instance = newProperty(0, 0,null);
  
  /**
   * Get the <code>instance</code> property.
   * @see com.tridium.nrio.components.BUIPointEntry#instance
   */
  public int getInstance() { return getInt(instance); }
  
  /**
   * Set the <code>instance</code> property.
   * @see com.tridium.nrio.components.BUIPointEntry#instance
   */
  public void setInstance(int v) { setInt(instance,v,null); }

////////////////////////////////////////////////////////////////
// Property "usedByPoint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>usedByPoint</code> property.
   * @see com.tridium.nrio.components.BUIPointEntry#getUsedByPoint
   * @see com.tridium.nrio.components.BUIPointEntry#setUsedByPoint
   */
  public static final Property usedByPoint = newProperty(0, "",null);
  
  /**
   * Get the <code>usedByPoint</code> property.
   * @see com.tridium.nrio.components.BUIPointEntry#usedByPoint
   */
  public String getUsedByPoint() { return getString(usedByPoint); }
  
  /**
   * Set the <code>usedByPoint</code> property.
   * @see com.tridium.nrio.components.BUIPointEntry#usedByPoint
   */
  public void setUsedByPoint(String v) { setString(usedByPoint,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BUIPointEntry.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BUIPointEntry(BNrioIoTypeEnum type, int instance)
  {
    setIoType(type);
    setInstance(instance);
  }
  public BUIPointEntry(){}

  public boolean matches(BComponent point)
  {
    if(!(point instanceof BControlPoint) )
      return false;
    BControlPoint cp = (BControlPoint)point;
    BAbstractProxyExt proxy = cp.getProxyExt();
    if( !(proxy instanceof BNrio16ProxyExt) )
      return false;
    if( !((BNrio16ProxyExt)proxy).getEnabled() )
      return false;
    int proxInstance = ((BNrio16ProxyExt)proxy).getInstance();
    if( getInstance() != proxInstance)
      return false;
    if( cp instanceof BBooleanWritable )
      return getIoType().equals(BNrioIoTypeEnum.relayOutput);
    if( cp instanceof BBooleanPoint )
      return getIoType().equals(BNrioIoTypeEnum.universalInput);
    if( cp instanceof BNumericWritable )
      return getIoType().equals(BNrioIoTypeEnum.analogOutput);
    if( cp instanceof BNumericPoint )
      return getIoType().equals(BNrioIoTypeEnum.universalInput);
    return false;
  }

  public boolean isMatchable(BComponent point)
  {
    if(!(point instanceof BControlPoint) )
      return false;
    BControlPoint cp = (BControlPoint)point;
    BAbstractProxyExt proxy = cp.getProxyExt();
    if( !(proxy instanceof BUiProxyExt) )
      return false;
    int proxInstance = ((BUiProxyExt)proxy).getInstance();
    if( proxInstance != 0)
      return false;

    if( cp instanceof BBooleanWritable )
      return getIoType().equals(BNrioIoTypeEnum.relayOutput);


    return ( (getIoType().equals(BNrioIoTypeEnum.digitalInput)) && (cp instanceof BBooleanPoint) );  
  }
}