/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio;

import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.IoModuleIOStatus;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.WriteConfigMessage;
import com.tridium.nrio.messages.WriteDOMessage;
import com.tridium.nrio.points.BNrioIOPoints;
import com.tridium.nrio.points.BNrioPointDeviceExt;

/**
 * BNrioInputOutputModule represents a Nrio IO Module
 *
 * @author    Andy Saunders       
 * @creation  12 Jan 06
 * @version   $Revision$ $Date: 8/29/2005 10:21:10 AM$
 * @since     Baja 1.0
 */
public class BNrioInputOutputModule
  extends BNrioDevice
{ 
  public static final Property deviceType = newProperty(Flags.READONLY, BNrioDeviceTypeEnum.remoteInputOutput,null);
 
 
  /*-
  class BNrioInputOutputModule
  {
    actions
    {
      writeConfig()
       flags{hidden}
    }
        
    properties
    {
      points: BNrioPointDeviceExt
      default{[ new BNrioIOPoints() ]}

    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.BNrioInputOutputModule(4139536924)1.0$ @*/
/* Generated Wed Jan 07 10:49:51 EST 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "points"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>points</code> property.
   * @see com.tridium.nrio.BNrioInputOutputModule#getPoints
   * @see com.tridium.nrio.BNrioInputOutputModule#setPoints
   */
  public static final Property points = newProperty(0, new BNrioIOPoints(),null);
  
  /**
   * Get the <code>points</code> property.
   * @see com.tridium.nrio.BNrioInputOutputModule#points
   */
  public BNrioPointDeviceExt getPoints() { return (BNrioPointDeviceExt)get(points); }
  
  /**
   * Set the <code>points</code> property.
   * @see com.tridium.nrio.BNrioInputOutputModule#points
   */
  public void setPoints(BNrioPointDeviceExt v) { set(points,v,null); }

////////////////////////////////////////////////////////////////
// Action "writeConfig"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>writeConfig</code> action.
   * @see com.tridium.nrio.BNrioInputOutputModule#writeConfig()
   */
  public static final Action writeConfig = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>writeConfig</code> action.
   * @see com.tridium.nrio.BNrioInputOutputModule#writeConfig
   */
  public void writeConfig() { invoke(writeConfig,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNrioInputOutputModule.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
    if( ! isRunning() )
      return;
    if(p.equals(status))
    {
      if(isDown() || isDisabled())
      {
        // clear lastWriteData
        lastWriteValue = 0;
      }
    }
  }


  public void doWriteConfig()
  {
    sendWriteConfig();
//    if(sendWriteConfig() == NrioMessageConst.MESSAGE_STATUS_OK)
//      System.out.println("write config was OK");
  }

  public int sendWriteConfig()
  {
    BNrioNetwork network = (BNrioNetwork)getNetwork();
    WriteConfigMessage cReq = new WriteConfigMessage(getAddress(), 0x0000);
    NrioMessage cRsp = network.sendNrioMessage(cReq);
    return cRsp.getStatus();
  }

  public int setDoValue(boolean value, int instance)
  {
    int mask = 0x0080 << instance;
    setWrDoValue(value,mask);
    //return doWriteDoValues();
    return 0;
  }

  public synchronized void setWrDoValue(boolean value, int mask)
  {
    if(value)
      wrDoValue = wrDoValue | mask;
    else
      wrDoValue = wrDoValue & ~mask;
    ((BNrioNetwork)getNetwork()).interruptWriteThread();
  }

  public int doWriteDoValues()
  {
    BNrioNetwork network = (BNrioNetwork)getNetwork();
    int thisWrite = wrDoValue;
    if(thisWrite != lastWriteValue)
    {
      //System.out.println("Thread: " + Thread.currentThread().getName() + " device: " + getAddress() + " write: " + Integer.toHexString(wrDoValue));
      WriteDOMessage req = new WriteDOMessage(getAddress(), thisWrite );
      NrioMessage rsp = network.sendNrioMessage(req);
      if( rsp != null && rsp.getStatus() == 0)
      {
       if(!getFirstPing())
        pingOk();
        lastWriteValue = thisWrite;
      }
      return rsp.getStatus();
    }
    return 0;
  }

  public void doDumpIoMap()
  {
    BOrd[] map = getUsedDiArray();
    {
      System.out.println("Digital input use map:");
      for(int i=0; i < map.length; i++)
      {
        System.out.println("   di" + (i+1) + " used = " + map[i]);
      }
    }
    map = getUsedRelayArray();
    {
      System.out.println("Relay output use map:");
      for(int i=0; i < map.length; i++)
      {
        System.out.println("   ro" + (i+1) + " used = " + map[i]);
      }
    }
    map = getUsedSdiArray();
    {
      System.out.println("Sdi use map:");
      for(int i=0; i < map.length; i++)
      {
        System.out.println("   sdi" + (i+1) + " used = " + map[i]);
      }
    }
  }

  /**
 * Return the boolean array that indiates how many relays are supported and which are
 *   currently assigned.  A true value will indicate that a relay is assigned.
 */
  public BOrd[] getUsedRelayArray()
  {
    return getUsedRelayArray(8);
  }

  /**
 * Return the boolean array that indiates how many digital inputs are supported and which are
 *   currently assigned.  A true value will indicate that a digital input is assigned.
 */
  public BOrd[] getUsedDiArray()
  {
    return getUsedDiArray(2);
  }

  /**
 * Return the boolean array that indiates how many supervised digital inputs are supported 
 *    and which are currently assigned.  
 *    A true value will indicate that a digital input is assigned.
 */
  public BOrd[] getUsedSdiArray()
  {
    return getUsedSdiArray(8);
  }


  // must be overridden by subclasses
  public void updateProxyValues()
  {
    byte[] statusBytes = ((BIoStatus)getIoStatus()).copyBytes();
    if(statusBytes.length < 12)
      return;
    NrioMessage statusMsg = new NrioMessage();
    statusMsg.decodeFromBytes(statusBytes, statusBytes.length);

    ((BNrioIOPoints)getPoints()).setIoStatus(new IoModuleIOStatus(statusMsg.getData()));
  }
  
//  public String toString(Context cx)
//  {
//     StringBuffer b = new StringBuffer(); 
//     b.append(getStatus().toString()).append(" ");
//     BNrioIOPoints points = (BNrioIOPoints) getPoints();
//     
//     return b.toString();
//  }

  private int wrDoValue = 0;
  private int lastWriteValue = 0;
  private static byte[] NO_DATA = new byte[0];

}

