/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio;

import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.points.BNrioPointDeviceExt;


/**
 * BNrioDualDevice represents a device
 *
 * @author    Andy Saunders       
 * @creation  21 Jan 02
 * @version   $Revision$ $Date: 8/29/2005 10:21:10 AM$
 * @since     Baja 1.0
 */

@NiagaraType
@NiagaraProperty
  (
    override = true,
    name = "address", type = "int", defaultValue = "0",
    flags = Flags.READONLY | Flags.DEFAULT_ON_CLONE,
    facets = {@Facet(name = "BFacets.MIN", value = "0"),
              @Facet(name = "BFacets.MAX", value = "15")}
  )
@NiagaraProperty
  (
    override = true,
    name = "deviceType",
    type = "BNrioDeviceTypeEnum",
    flags = Flags.READONLY,
    defaultValue = "BNrioDeviceTypeEnum.none"
  )
@NiagaraProperty
  (
    override = true,
    name = "uid",
    type = "BBlob",
    flags = Flags.READONLY | Flags.DEFAULT_ON_CLONE,
    defaultValue = "BBlob.make( defaultUid )",
    facets = {@Facet(name = "BFacets.FIELD_EDITOR", value = "BString.make(\"nrio:FlexBlobFE\")") })
@NiagaraProperty
  (
    override = true,
    name = "installedVersion",
    type = "String",
    flags = Flags.READONLY | Flags.DEFAULT_ON_CLONE,
    defaultValue = ""
  )
@NiagaraProperty
  (
    override = true,
    name = "availableVersion",
    type = "String",
    flags = Flags.READONLY,
    defaultValue = "")
@NiagaraProperty
  (
    override = true,
    name = "winkOutput",
    type = "int",
    defaultValue = "1",
    facets = {@Facet(name = "BFacets.MIN", value = "1"), @Facet(name = "BFacets.MAX", value = "8")}
  )
@NiagaraProperty
  (
    override = true,
    name = "winkDuration",
    type = "BRelTime",
    defaultValue = "BRelTime.makeSeconds(10)",
    facets =
      {
        @Facet(name = "BFacets.MAX", value ="BRelTime.makeSeconds(60)"),
        @Facet(name = "BFacets.MIN", value = "BRelTime.makeSeconds(5)")
      }
  )
@NiagaraProperty
  (
    override = true,
    name = "points",
    type = "BNrioPointDeviceExt",
    defaultValue = "new BNrioPointDeviceExt()"
  )
@NiagaraProperty
  (
    override = true,
    name = "ioStatus",
    type = "BStruct",
    flags = Flags.READONLY | Flags.DEFAULT_ON_CLONE,
    defaultValue = "new BIoStatus()"
  )
@NiagaraProperty
  (
    name = "io34Sec",
    type = "BNrioDevice",
    defaultValue = "new BNrioDevice()"
  )

@NiagaraAction(name = "winkDevice", flags = Flags.HIDDEN, override = true)
@NiagaraAction(name = "winkTimeout", flags = Flags.HIDDEN, override = true)
@NiagaraAction(name = "winkCancel", flags = Flags.HIDDEN, override = true)
@NiagaraAction(name = "enablePolling", flags = Flags.HIDDEN, override = true)
@NiagaraAction(name = "disablePolling", flags = Flags.HIDDEN, override = true)
@NiagaraAction(name = "setPingOk", flags = Flags.HIDDEN, override = true)
@NiagaraAction(name = "setAddressAndPing", flags = Flags.HIDDEN, override = true)
@NiagaraAction(name = "dumpIoMap", flags = Flags.HIDDEN, override = true)
@NiagaraAction(name = "readInfoMemory", flags = Flags.HIDDEN, override = true)
@NiagaraAction(name = "clearInfoMemory", flags = Flags.HIDDEN, override = true)


public class BNrioDualDevice
extends BNrioDevice
{
  static byte[] defaultUid = { (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, };
  public static final Action download = newAction(Flags.ASYNC | Flags.HIDDEN,new BDownloadParameters(),null);
  public static final Action upload = newAction(Flags.ASYNC | Flags.HIDDEN,new BUploadParameters(),null);

/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.nrio.BNrioDualDevice(1512056840)1.0$ @*/
/* Generated Thu Nov 17 11:10:53 EST 2016 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "address"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code address} property.
   * @see #getAddress
   * @see #setAddress
   */
  public static final Property address = newProperty(Flags.READONLY | Flags.DEFAULT_ON_CLONE, 0, BFacets.make(BFacets.make(BFacets.MIN, 0), BFacets.make(BFacets.MAX, 15)));

////////////////////////////////////////////////////////////////
// Property "deviceType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code deviceType} property.
   * @see #getDeviceType
   * @see #setDeviceType
   */
  public static final Property deviceType = newProperty(Flags.READONLY, BNrioDeviceTypeEnum.none, null);

////////////////////////////////////////////////////////////////
// Property "uid"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code uid} property.
   * @see #getUid
   * @see #setUid
   */
  public static final Property uid = newProperty(Flags.READONLY | Flags.DEFAULT_ON_CLONE, BBlob.make( defaultUid ), BFacets.make(BFacets.FIELD_EDITOR, BString.make("nrio:FlexBlobFE")));

////////////////////////////////////////////////////////////////
// Property "installedVersion"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code installedVersion} property.
   * @see #getInstalledVersion
   * @see #setInstalledVersion
   */
  public static final Property installedVersion = newProperty(Flags.READONLY | Flags.DEFAULT_ON_CLONE, "", null);

////////////////////////////////////////////////////////////////
// Property "availableVersion"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code availableVersion} property.
   * @see #getAvailableVersion
   * @see #setAvailableVersion
   */
  public static final Property availableVersion = newProperty(Flags.READONLY, "", null);

////////////////////////////////////////////////////////////////
// Property "winkOutput"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code winkOutput} property.
   * @see #getWinkOutput
   * @see #setWinkOutput
   */
  public static final Property winkOutput = newProperty(0, 1, BFacets.make(BFacets.make(BFacets.MIN, 1), BFacets.make(BFacets.MAX, 8)));

////////////////////////////////////////////////////////////////
// Property "winkDuration"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code winkDuration} property.
   * @see #getWinkDuration
   * @see #setWinkDuration
   */
  public static final Property winkDuration = newProperty(0, BRelTime.makeSeconds(10), BFacets.make(BFacets.make(BFacets.MAX, BRelTime.makeSeconds(60)), BFacets.make(BFacets.MIN, BRelTime.makeSeconds(5))));

////////////////////////////////////////////////////////////////
// Property "points"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code points} property.
   * @see #getPoints
   * @see #setPoints
   */
  public static final Property points = newProperty(0, new BNrioPointDeviceExt(), null);

////////////////////////////////////////////////////////////////
// Property "ioStatus"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code ioStatus} property.
   * @see #getIoStatus
   * @see #setIoStatus
   */
  public static final Property ioStatus = newProperty(Flags.READONLY | Flags.DEFAULT_ON_CLONE, new BIoStatus(), null);

////////////////////////////////////////////////////////////////
// Property "io34Sec"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code io34Sec} property.
   * @see #getIo34Sec
   * @see #setIo34Sec
   */
  public static final Property io34Sec = newProperty(0, new BNrioDevice(), null);
  
  /**
   * Get the {@code io34Sec} property.
   * @see #io34Sec
   */
  public BNrioDevice getIo34Sec() { return (BNrioDevice)get(io34Sec); }
  
  /**
   * Set the {@code io34Sec} property.
   * @see #io34Sec
   */
  public void setIo34Sec(BNrioDevice v) { set(io34Sec, v, null); }

////////////////////////////////////////////////////////////////
// Action "winkDevice"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code winkDevice} action.
   * @see #winkDevice()
   */
  public static final Action winkDevice = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Action "winkTimeout"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code winkTimeout} action.
   * @see #winkTimeout()
   */
  public static final Action winkTimeout = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Action "winkCancel"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code winkCancel} action.
   * @see #winkCancel()
   */
  public static final Action winkCancel = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Action "enablePolling"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code enablePolling} action.
   * @see #enablePolling()
   */
  public static final Action enablePolling = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Action "disablePolling"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code disablePolling} action.
   * @see #disablePolling()
   */
  public static final Action disablePolling = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Action "setPingOk"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code setPingOk} action.
   * @see #setPingOk()
   */
  public static final Action setPingOk = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Action "setAddressAndPing"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code setAddressAndPing} action.
   * @see #setAddressAndPing()
   */
  public static final Action setAddressAndPing = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Action "dumpIoMap"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code dumpIoMap} action.
   * @see #dumpIoMap()
   */
  public static final Action dumpIoMap = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Action "readInfoMemory"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code readInfoMemory} action.
   * @see #readInfoMemory()
   */
  public static final Action readInfoMemory = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Action "clearInfoMemory"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code clearInfoMemory} action.
   * @see #clearInfoMemory()
   */
  public static final Action clearInfoMemory = newAction(Flags.HIDDEN, null);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNrioDualDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/



////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////


}

