/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.nrio;

import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nrio.components.BSdiValueConfig;
import com.tridium.nrio.job.BM2mLearnDeviceJob;
import com.tridium.nrio.messages.NrioMessageConst;



/**
 * BNrioNetwork is the base container for BNrioDevices.   
 *
 * @author    Andy Saunders       
 * @creation  19 Dec 08
 * @version   $Revision$ $Date: 9/12/2005 2:48:27 PM$
 * @since     Niagara 3.0
 */
public class BM2mIoNetwork
  extends BNrioNetwork
  implements Runnable, NrioMessageConst
{ 

  public static final Property portName = newProperty(Flags.DEFAULT_ON_CLONE | Flags.READONLY, "COM3",null);
  public static final Property trunk = newProperty(Flags.DEFAULT_ON_CLONE | Flags.READONLY, 1,null);
  public static final Property baudRate = newProperty(Flags.READONLY, BSerialBaudRate.baud115200,null);
  public static final Property sdiValueConfig = newProperty(Flags.HIDDEN, new BSdiValueConfig(),null);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BM2mIoNetwork.class);

  public void started()
  throws Exception
  {
    super.started();
    //setMaxDevices(1);
  }

  public void atSteadyState()
  {
    BOrd jobOrd = doSubmitDeviceDiscoveryJob();
    BM2mLearnDeviceJob job = (BM2mLearnDeviceJob)jobOrd.get(this);

  }

  public BNrio16Module getLocalIoModule()
  {
    BDevice[] devices = getDevices();
    if(devices == null || devices.length == 0)
      return null;
    if(devices[0] instanceof BNrio16Module)
      return (BNrio16Module)devices[0];
    else 
      return null;
  }

  public BOrd doSubmitDeviceDiscoveryJob()
  {
    if(getStatus().isDisabled())
      return null;
    BM2mLearnDeviceJob job = new BM2mLearnDeviceJob(this);
    return job.submit(null);
  }

  
}
