/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.tuning;

import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.sys.*;
import javax.baja.units.UnitDatabase;

/**
 * BLonTuningPolicy.
 *
 * @author    Robert Adams
 * @creation  03 June 2005
 * @version   $Revision$ $Date$
 * @since     Niagara 3 lonworks 1.0
 */
public class BLonTuningPolicy
  extends BTuningPolicy
{
  /*-
  class BLonTuningPolicy
  {
    properties
    {
      pollFrequency: BPollFrequency
        default {[ BPollFrequency.normal ]}
      writeDelay : int
        default {[ 0 ]}
        slotfacets {[ BFacets.make(BFacets.MIN,BInteger.make(0),BFacets.MAX,BInteger.make(1000),BFacets.UNITS,UnitDatabase.getUnit("millisecond")) ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.tuning.BLonTuningPolicy(2893399196)1.0$ @*/
/* Generated Fri Feb 03 14:29:43 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "pollFrequency"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pollFrequency</code> property.
   * @see javax.baja.lonworks.tuning.BLonTuningPolicy#getPollFrequency
   * @see javax.baja.lonworks.tuning.BLonTuningPolicy#setPollFrequency
   */
  public static final Property pollFrequency = newProperty(0, BPollFrequency.normal,null);
  
  /**
   * Get the <code>pollFrequency</code> property.
   * @see javax.baja.lonworks.tuning.BLonTuningPolicy#pollFrequency
   */
  public BPollFrequency getPollFrequency() { return (BPollFrequency)get(pollFrequency); }
  
  /**
   * Set the <code>pollFrequency</code> property.
   * @see javax.baja.lonworks.tuning.BLonTuningPolicy#pollFrequency
   */
  public void setPollFrequency(BPollFrequency v) { set(pollFrequency,v,null); }

////////////////////////////////////////////////////////////////
// Property "writeDelay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>writeDelay</code> property.
   * @see javax.baja.lonworks.tuning.BLonTuningPolicy#getWriteDelay
   * @see javax.baja.lonworks.tuning.BLonTuningPolicy#setWriteDelay
   */
  public static final Property writeDelay = newProperty(0, 0,BFacets.make(BFacets.MIN,BInteger.make(0),BFacets.MAX,BInteger.make(1000),BFacets.UNITS,UnitDatabase.getUnit("millisecond")));
  
  /**
   * Get the <code>writeDelay</code> property.
   * @see javax.baja.lonworks.tuning.BLonTuningPolicy#writeDelay
   */
  public int getWriteDelay() { return getInt(writeDelay); }
  
  /**
   * Set the <code>writeDelay</code> property.
   * @see javax.baja.lonworks.tuning.BLonTuningPolicy#writeDelay
   */
  public void setWriteDelay(int v) { setInt(writeDelay,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonTuningPolicy.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Default constructor.
   */
  public BLonTuningPolicy()
  {
  }

  public BLonTuningPolicy( BRelTime minWriteTime,
                           BRelTime maxWriteTime,
                           boolean  writeOnStart,
                           boolean  writeOnUp,
                           boolean  writeOnEnabled,
                           BRelTime staleTime)
  {
    setMinWriteTime(minWriteTime);    
    setMaxWriteTime(maxWriteTime);    
    setWriteOnStart(writeOnStart);    
    setWriteOnUp(writeOnUp);    
    setWriteOnEnabled(writeOnEnabled);    
    setStaleTime(staleTime);    
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  /**
   * Can only go in a LonTuningPolicyMap.
   */
  public boolean isParentLegal(BComponent parent)
    { return parent instanceof BLonTuningPolicyMap; }

/*
  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
    if (!isRunning()) return;
    if (p.equals(useCov))
    {
      ((BLonNetwork)((BLonTuningPolicyMap)getParent()).getNetwork())
        .tuningChanged(this, cx);
    }
  }
*/
  
}