/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.proxy;

import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BLonStringProxyExt is the proxy extension for 
 * <code>BStringPoint</code>. It will link a single
 * boolean point to a lonworks <code>BLonPrimitive</code>.
 * The appropriate conversions will be performed.
 *
 * @author    Robert Adams
 * @creation  19 Dec 01
 * @version   $Revision: 4$ $Date: 10/18/01 2:56:42 PM$
 * @since     Niagara 3.0
 */
public final class BLonStringProxyExt
  extends BLonProxyExt
{

  /*-
  class BLonStringProxyExt
  {
    properties
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.proxy.BLonStringProxyExt(1594341571)1.0$ @*/
/* Generated Tue Apr 06 10:08:44 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonStringProxyExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/




////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Get data point value to as a BStatusString.
   */
  public BStatusValue getStatusValue(BLonPrimitive newValue)
  {
    return new BStatusString(newValue.getDataAsString());
  }
  
  
  /**
   * Convert a BStatusString to a BLonString.
   */
  public BLonPrimitive getPrimitiveValue(BStatusValue value)
  {
    BLonData dataPoint = getDataPoint();    
    String val = ((BStatusString)value).getValue();
    return ((BLonPrimitive)dataPoint.get(targetProp)).makeFromString(val);
  }
 
}
