/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonCalendarTypeEnum;
import javax.baja.lonworks.enums.BLonDaysOfWeekEnum;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file represents SNVT_time_zone.
 * <p>
 *
 * @author    Robert Adams
 * @creation  8 Aug 01
 * @version   $Revision: 3$ $Date: 9/18/01 9:50:10 AM$
 * @since     Niagara 3.0
 */
public class BLonTimeZone
  extends BLonData
{
/*
byte offsets in SNVT_time_zone
typedef struct {

0  s32_type    second_time_offset;
4  calendar_type_t type_of_description;
5  unsigned short  hour_of_start_DST;
6  unsigned short  minute_of_start_DST;
7  unsigned short  second_of_start_DST;
  union {
8    unsigned long G_day_of_start_DST;
8    unsigned long J_day_of_start_DST;
    struct {
8      unsigned short  month_of_start_DST  :4;
8      unsigned short  week_of_start_DST   :3;
9      SNVT_date_day dateday_of_start_DST;
    } M_start_DST;
  } start_DST;

10  unsigned short  hour_of_end_DST;
11  unsigned short  minute_of_end_DST;
12  unsigned short  second_of_end_DST;
  union {
13    unsigned long G_day_of_end_DST;
13    unsigned long J_day_of_end_DST;
    struct {
13      unsigned short  month_of_end_DST    :4;
13      unsigned short  week_of_end_DST     :3;
14      SNVT_date_day   dateday_of_end_DST;
    } M_end_DST;
  } end_DST;
} SNVT_time_zone;
*/

  /*-

  class BLonTimeZone
  {
    properties
    {
      secondTimeOffset : BLonFloat 
        default {[ BLonFloat.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.s32, -86400F, 86400F, 1, null) ]}
      typeOfDescription : BLonEnum
        default {[ BLonEnum.make(BLonCalendarTypeEnum.calNul) ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      hourOfStartDST : BLonFloat 
        default {[ BLonFloat.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 23, 1, 5, null) ]}
      minuteOfStartDST : BLonFloat 
        default {[ BLonFloat.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 59, 1, 6, null) ]}
      secondOfStartDST : BLonFloat 
        default {[ BLonFloat.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 59, 1, 7, null) ]}
      GdayOfStartDST : BLonFloat 
        default {[ BLonFloat.DEFAULT ]} 
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16,true,0F, true,365F, 1F,0F, true,8,0, false,0F, 1, null) ]}
      JdayOfStartDST : BLonFloat
        default {[ BLonFloat.DEFAULT ]} 
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16,true,1F, true,365F, 1F,0F, true,8,0, false,0F, 1, null) ]}
      MmonthOfStartDST : BLonFloat
        default {[ BLonFloat.DEFAULT ]} 
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub,true,1F, true,12F, 1F,0F, true,8,4, false,0F, 4, null) ]}
      MweekOfStartDST : BLonFloat
        default {[ BLonFloat.DEFAULT ]} 
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub,true,1F, true,5F, 1F,0F, true,8,1, false,0F, 3, null) ]}
      MdatedayOfStartDST : BLonEnum
        default {[ BLonEnum.make(BLonDaysOfWeekEnum.daySun) ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, 9) ]}
      hourOfEndDST : BLonFloat 
        default {[ BLonFloat.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 23, 1, 10, null) ]}
      minuteOfEndDST : BLonFloat 
        default {[ BLonFloat.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 59, 1, 11, null) ]}
      secondOfEndDST : BLonFloat 
        default {[ BLonFloat.DEFAULT ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 59, 1, 12, null) ]}
      GdayOfEndDST : BLonFloat 
        default {[ BLonFloat.DEFAULT ]} 
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16,true,0F, true,365F, 1F,0F, true,13,0, false,0F, 1, null) ]}
      JdayOfEndDST : BLonFloat
        default {[ BLonFloat.DEFAULT ]} 
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16,true,1F, true,365F, 1F,0F, true,13,0, false,0F, 1, null) ]}
      MmonthOfEndDST : BLonFloat
        default {[ BLonFloat.DEFAULT ]} 
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub,true,1F, true,12F, 1F,0F, true,13,4, false,0F, 4, null) ]}
      MweekOfEndDST : BLonFloat
        default {[ BLonFloat.DEFAULT ]} 
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub,true,1F, true,5F, 1F,0F, true,13,1, false,0F, 3, null) ]}
      MgatedayOfEndDST : BLonEnum
        default {[ BLonEnum.make(BLonDaysOfWeekEnum.daySun) ]}
        slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, 14) ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonTimeZone(772130620)1.0$ @*/
/* Generated Tue Jan 26 09:40:18 EST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "secondTimeOffset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>secondTimeOffset</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getSecondTimeOffset
   * @see javax.baja.lonworks.londata.BLonTimeZone#setSecondTimeOffset
   */
  public static final Property secondTimeOffset = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.s32, -86400F, 86400F, 1, null));
  
  /**
   * Get the <code>secondTimeOffset</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#secondTimeOffset
   */
  public BLonFloat getSecondTimeOffset() { return (BLonFloat)get(secondTimeOffset); }
  
  /**
   * Set the <code>secondTimeOffset</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#secondTimeOffset
   */
  public void setSecondTimeOffset(BLonFloat v) { set(secondTimeOffset,v,null); }

////////////////////////////////////////////////////////////////
// Property "typeOfDescription"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>typeOfDescription</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getTypeOfDescription
   * @see javax.baja.lonworks.londata.BLonTimeZone#setTypeOfDescription
   */
  public static final Property typeOfDescription = newProperty(0, BLonEnum.make(BLonCalendarTypeEnum.calNul),LonFacetsUtil.makeFacets(BLonElementType.e8, null));
  
  /**
   * Get the <code>typeOfDescription</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#typeOfDescription
   */
  public BLonEnum getTypeOfDescription() { return (BLonEnum)get(typeOfDescription); }
  
  /**
   * Set the <code>typeOfDescription</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#typeOfDescription
   */
  public void setTypeOfDescription(BLonEnum v) { set(typeOfDescription,v,null); }

////////////////////////////////////////////////////////////////
// Property "hourOfStartDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>hourOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getHourOfStartDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setHourOfStartDST
   */
  public static final Property hourOfStartDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 23, 1, 5, null));
  
  /**
   * Get the <code>hourOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#hourOfStartDST
   */
  public BLonFloat getHourOfStartDST() { return (BLonFloat)get(hourOfStartDST); }
  
  /**
   * Set the <code>hourOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#hourOfStartDST
   */
  public void setHourOfStartDST(BLonFloat v) { set(hourOfStartDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "minuteOfStartDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>minuteOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getMinuteOfStartDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setMinuteOfStartDST
   */
  public static final Property minuteOfStartDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 59, 1, 6, null));
  
  /**
   * Get the <code>minuteOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#minuteOfStartDST
   */
  public BLonFloat getMinuteOfStartDST() { return (BLonFloat)get(minuteOfStartDST); }
  
  /**
   * Set the <code>minuteOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#minuteOfStartDST
   */
  public void setMinuteOfStartDST(BLonFloat v) { set(minuteOfStartDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "secondOfStartDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>secondOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getSecondOfStartDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setSecondOfStartDST
   */
  public static final Property secondOfStartDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 59, 1, 7, null));
  
  /**
   * Get the <code>secondOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#secondOfStartDST
   */
  public BLonFloat getSecondOfStartDST() { return (BLonFloat)get(secondOfStartDST); }
  
  /**
   * Set the <code>secondOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#secondOfStartDST
   */
  public void setSecondOfStartDST(BLonFloat v) { set(secondOfStartDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "GdayOfStartDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>GdayOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getGdayOfStartDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setGdayOfStartDST
   */
  public static final Property GdayOfStartDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16,true,0F, true,365F, 1F,0F, true,8,0, false,0F, 1, null));
  
  /**
   * Get the <code>GdayOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#GdayOfStartDST
   */
  public BLonFloat getGdayOfStartDST() { return (BLonFloat)get(GdayOfStartDST); }
  
  /**
   * Set the <code>GdayOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#GdayOfStartDST
   */
  public void setGdayOfStartDST(BLonFloat v) { set(GdayOfStartDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "JdayOfStartDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>JdayOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getJdayOfStartDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setJdayOfStartDST
   */
  public static final Property JdayOfStartDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16,true,1F, true,365F, 1F,0F, true,8,0, false,0F, 1, null));
  
  /**
   * Get the <code>JdayOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#JdayOfStartDST
   */
  public BLonFloat getJdayOfStartDST() { return (BLonFloat)get(JdayOfStartDST); }
  
  /**
   * Set the <code>JdayOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#JdayOfStartDST
   */
  public void setJdayOfStartDST(BLonFloat v) { set(JdayOfStartDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "MmonthOfStartDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>MmonthOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getMmonthOfStartDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setMmonthOfStartDST
   */
  public static final Property MmonthOfStartDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub,true,1F, true,12F, 1F,0F, true,8,4, false,0F, 4, null));
  
  /**
   * Get the <code>MmonthOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MmonthOfStartDST
   */
  public BLonFloat getMmonthOfStartDST() { return (BLonFloat)get(MmonthOfStartDST); }
  
  /**
   * Set the <code>MmonthOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MmonthOfStartDST
   */
  public void setMmonthOfStartDST(BLonFloat v) { set(MmonthOfStartDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "MweekOfStartDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>MweekOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getMweekOfStartDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setMweekOfStartDST
   */
  public static final Property MweekOfStartDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub,true,1F, true,5F, 1F,0F, true,8,1, false,0F, 3, null));
  
  /**
   * Get the <code>MweekOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MweekOfStartDST
   */
  public BLonFloat getMweekOfStartDST() { return (BLonFloat)get(MweekOfStartDST); }
  
  /**
   * Set the <code>MweekOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MweekOfStartDST
   */
  public void setMweekOfStartDST(BLonFloat v) { set(MweekOfStartDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "MdatedayOfStartDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>MdatedayOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getMdatedayOfStartDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setMdatedayOfStartDST
   */
  public static final Property MdatedayOfStartDST = newProperty(0, BLonEnum.make(BLonDaysOfWeekEnum.daySun),LonFacetsUtil.makeFacets(BLonElementType.e8, 9));
  
  /**
   * Get the <code>MdatedayOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MdatedayOfStartDST
   */
  public BLonEnum getMdatedayOfStartDST() { return (BLonEnum)get(MdatedayOfStartDST); }
  
  /**
   * Set the <code>MdatedayOfStartDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MdatedayOfStartDST
   */
  public void setMdatedayOfStartDST(BLonEnum v) { set(MdatedayOfStartDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "hourOfEndDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>hourOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getHourOfEndDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setHourOfEndDST
   */
  public static final Property hourOfEndDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 23, 1, 10, null));
  
  /**
   * Get the <code>hourOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#hourOfEndDST
   */
  public BLonFloat getHourOfEndDST() { return (BLonFloat)get(hourOfEndDST); }
  
  /**
   * Set the <code>hourOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#hourOfEndDST
   */
  public void setHourOfEndDST(BLonFloat v) { set(hourOfEndDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "minuteOfEndDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>minuteOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getMinuteOfEndDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setMinuteOfEndDST
   */
  public static final Property minuteOfEndDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 59, 1, 11, null));
  
  /**
   * Get the <code>minuteOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#minuteOfEndDST
   */
  public BLonFloat getMinuteOfEndDST() { return (BLonFloat)get(minuteOfEndDST); }
  
  /**
   * Set the <code>minuteOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#minuteOfEndDST
   */
  public void setMinuteOfEndDST(BLonFloat v) { set(minuteOfEndDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "secondOfEndDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>secondOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getSecondOfEndDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setSecondOfEndDST
   */
  public static final Property secondOfEndDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 59, 1, 12, null));
  
  /**
   * Get the <code>secondOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#secondOfEndDST
   */
  public BLonFloat getSecondOfEndDST() { return (BLonFloat)get(secondOfEndDST); }
  
  /**
   * Set the <code>secondOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#secondOfEndDST
   */
  public void setSecondOfEndDST(BLonFloat v) { set(secondOfEndDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "GdayOfEndDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>GdayOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getGdayOfEndDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setGdayOfEndDST
   */
  public static final Property GdayOfEndDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16,true,0F, true,365F, 1F,0F, true,13,0, false,0F, 1, null));
  
  /**
   * Get the <code>GdayOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#GdayOfEndDST
   */
  public BLonFloat getGdayOfEndDST() { return (BLonFloat)get(GdayOfEndDST); }
  
  /**
   * Set the <code>GdayOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#GdayOfEndDST
   */
  public void setGdayOfEndDST(BLonFloat v) { set(GdayOfEndDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "JdayOfEndDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>JdayOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getJdayOfEndDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setJdayOfEndDST
   */
  public static final Property JdayOfEndDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16,true,1F, true,365F, 1F,0F, true,13,0, false,0F, 1, null));
  
  /**
   * Get the <code>JdayOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#JdayOfEndDST
   */
  public BLonFloat getJdayOfEndDST() { return (BLonFloat)get(JdayOfEndDST); }
  
  /**
   * Set the <code>JdayOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#JdayOfEndDST
   */
  public void setJdayOfEndDST(BLonFloat v) { set(JdayOfEndDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "MmonthOfEndDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>MmonthOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getMmonthOfEndDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setMmonthOfEndDST
   */
  public static final Property MmonthOfEndDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub,true,1F, true,12F, 1F,0F, true,13,4, false,0F, 4, null));
  
  /**
   * Get the <code>MmonthOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MmonthOfEndDST
   */
  public BLonFloat getMmonthOfEndDST() { return (BLonFloat)get(MmonthOfEndDST); }
  
  /**
   * Set the <code>MmonthOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MmonthOfEndDST
   */
  public void setMmonthOfEndDST(BLonFloat v) { set(MmonthOfEndDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "MweekOfEndDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>MweekOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getMweekOfEndDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setMweekOfEndDST
   */
  public static final Property MweekOfEndDST = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub,true,1F, true,5F, 1F,0F, true,13,1, false,0F, 3, null));
  
  /**
   * Get the <code>MweekOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MweekOfEndDST
   */
  public BLonFloat getMweekOfEndDST() { return (BLonFloat)get(MweekOfEndDST); }
  
  /**
   * Set the <code>MweekOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MweekOfEndDST
   */
  public void setMweekOfEndDST(BLonFloat v) { set(MweekOfEndDST,v,null); }

////////////////////////////////////////////////////////////////
// Property "MgatedayOfEndDST"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>MgatedayOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#getMgatedayOfEndDST
   * @see javax.baja.lonworks.londata.BLonTimeZone#setMgatedayOfEndDST
   */
  public static final Property MgatedayOfEndDST = newProperty(0, BLonEnum.make(BLonDaysOfWeekEnum.daySun),LonFacetsUtil.makeFacets(BLonElementType.e8, 14));
  
  /**
   * Get the <code>MgatedayOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MgatedayOfEndDST
   */
  public BLonEnum getMgatedayOfEndDST() { return (BLonEnum)get(MgatedayOfEndDST); }
  
  /**
   * Set the <code>MgatedayOfEndDST</code> property.
   * @see javax.baja.lonworks.londata.BLonTimeZone#MgatedayOfEndDST
   */
  public void setMgatedayOfEndDST(BLonEnum v) { set(MgatedayOfEndDST,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonTimeZone.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   *  Converts data to network byte format
   **/
  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(secondTimeOffset, out);
    primitiveToOutputStream(typeOfDescription, out );
    primitiveToOutputStream(hourOfStartDST, out );
    primitiveToOutputStream(minuteOfStartDST, out );
    primitiveToOutputStream(secondOfStartDST, out );
    
    int type = ((BLonCalendarTypeEnum)getTypeOfDescription().getEnum()).getOrdinal();
    if(type == BLonCalendarTypeEnum.CAL_GREG)
    {
      primitiveToOutputStream(GdayOfStartDST, out );
    }
    else if(type == BLonCalendarTypeEnum.CAL_JUL)
    {
      primitiveToOutputStream(JdayOfStartDST, out );
    }
    else
    {
      primitiveToOutputStream(MmonthOfStartDST, out );
      primitiveToOutputStream(MweekOfStartDST, out );
      primitiveToOutputStream(MdatedayOfStartDST, out );
    }
    primitiveToOutputStream(hourOfEndDST, out );
    primitiveToOutputStream(minuteOfEndDST, out );
    primitiveToOutputStream(secondOfEndDST, out );
    
    if(type == BLonCalendarTypeEnum.CAL_GREG)
    {
      primitiveToOutputStream(GdayOfEndDST, out );
    }
    else if(type == BLonCalendarTypeEnum.CAL_JUL)
    {
      primitiveToOutputStream(JdayOfEndDST, out );
    }
    else
    {
      primitiveToOutputStream(MmonthOfEndDST, out );
      primitiveToOutputStream(MweekOfEndDST, out );
      primitiveToOutputStream(MgatedayOfEndDST, out );
    }
  }
  
  /**
   *  Translates from network bytes. Sets the 
   *  value of the object to the state represented 
   *  by the given bytes.
   **/
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(secondTimeOffset , in );   
    primitiveFromInputStream(typeOfDescription, in);  
    primitiveFromInputStream(hourOfStartDST, in);     
    primitiveFromInputStream(minuteOfStartDST, in);  
    primitiveFromInputStream(secondOfStartDST, in);  
    
    int type = ((BLonCalendarTypeEnum)getTypeOfDescription().getEnum()).getOrdinal();
    if(type == BLonCalendarTypeEnum.CAL_GREG)
      primitiveFromInputStream(GdayOfStartDST, in);   
    else if(type == BLonCalendarTypeEnum.CAL_JUL)                                                                         
      primitiveFromInputStream(JdayOfStartDST, in);   
    else
    {  
      primitiveFromInputStream(MmonthOfStartDST, in);                                           
      primitiveFromInputStream(MweekOfStartDST, in);                                           
      primitiveFromInputStream(MdatedayOfStartDST, in);                                         
    }
    primitiveFromInputStream(hourOfEndDST, in);    
    primitiveFromInputStream(minuteOfEndDST, in);  
    primitiveFromInputStream(secondOfEndDST, in);  
    
    if(type == BLonCalendarTypeEnum.CAL_GREG)
      primitiveFromInputStream(GdayOfEndDST, in); 
    else if(type == BLonCalendarTypeEnum.CAL_JUL)                                                                     
      primitiveFromInputStream(JdayOfEndDST, in); 
    else
    {  
      primitiveFromInputStream(MmonthOfEndDST, in);  
      primitiveFromInputStream(MweekOfEndDST, in);  
      primitiveFromInputStream(MgatedayOfEndDST, in);
    }

  }


}