/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.enums.BLonRailAudioSensorTypeEnum;
import javax.baja.lonworks.enums.BLonRailAudioTypeEnum;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file represents SNVT_rac_ctrl.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  4 Sept 01
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:43 AM$
 * @since     Niagara 3.0
 */
public class BLonRacCtrl
  extends BLonData
{  
  /*
 <RacCtrl type="XTypeDef">
  <elem n="audioLine                  " qual="ub byt=0 bit=5 len=3 max=7.0"/>
  <elem n="duplexFull                 " qual="ub byt=0 bit=4 len=1"/>
  <elem n="destP2P                    " qual="ub byt=0 bit=3 len=1"/>
  <elem n="reserved                   " qual="ub byt=0 bit=0 len=3"/>
  <elem n="audioType                  " qual="e8" enumDef="RailAudioTypeT"/>
  <elem n="addrInitUnitId             " qual="ub byt=2 bit=4 len=4 max=8.0"/>
  <elem n="addrInitLocation           " qual="ub byt=2 bit=0 len=4"/>
  <elem n="addrInitCarId              " qual="ub byt=3 bit=3 len=5"/>
  <elem n="addrInitReserved           " qual="ub byt=3 bit=0 len=3"/>
  <elem n="addrInitAudioSensorType    " qual="e8" enumDef="RailAudioSensorTypeT"/>
  <elem n="addrTalkUnitId             " qual="ub byt=5 bit=4 len=4"/>
  <elem n="addrTalkLocation           " qual="ub byt=5 bit=0 len=4"/>
  <elem n="addrTalkCarId              " qual="ub byt=6 bit=3 len=5"/>
  <elem n="addrTalkReserved           " qual="ub byt=6 bit=0 len=3"/>
  <elem n="addrTalkAudioSensorType    " qual="e8" enumDef="RailAudioSensorTypeT"/>
  <elem n="addrDestP2PUnitId          " qual="ub byt=8 bit=4 len=4"/>
  <elem n="addrDestP2PLocation        " qual="ub byt=8 bit=0 len=4"/>
  <elem n="addrDestP2PCarId           " qual="ub byt=9 bit=3 len=5"/>
  <elem n="addrDestP2PReserved        " qual="ub byt=9 bit=0 len=3"/>
  <elem n="addrDestP2PAudioSensorType " qual="e8" enumDef="RailAudioSensorTypeT"/>
  <elem n="addrDestP2MMaskUnit        " qual="u8 byt=8"/>
  <elem n="addrDestP2MMaskCar         " qual="st len=4"/>
  <elem n="addrDestP2MMaskLocation    " qual="st len=2"/>
  <elem n="addrDestP2MMaskAudio       " qual="st len=3"/>
  <typeScope v="0,181"/>
 </RacCtrl>
  */

  /*-

  class BLonRacCtrl
  {
    properties
    {
      audioLine                    : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 0, 5, 3,  null) ]}
      duplexFull                   : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 0, 4, 1,  null) ]}
      destP2P                      : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 0, 3, 1,  null) ]}
      reserved                     : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 0, 0, 3,  null) ]}
      audioType                    : BLonEnum     default{[ BLonEnum.make(BLonRailAudioTypeEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      addrInitUnitId               : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 8, 1F, 0F, true, 2, 4, false, 0F, 4, null) ]}
      addrInitLocation             : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 2, 0, 4,  null) ]}
      addrInitCarId                : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 3, 5,  null) ]}
      addrInitReserved             : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 3,  null) ]}
      addrInitAudioSensorType      : BLonEnum     default{[ BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      addrTalkUnitId               : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 5, 4, 4,  null) ]}
      addrTalkLocation             : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 5, 0, 4,  null) ]}
      addrTalkCarId                : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 6, 3, 5,  null) ]}
      addrTalkReserved             : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 6, 0, 3,  null) ]}
      addrTalkAudioSensorType      : BLonEnum     default{[ BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      addrDestP2PUnitId            : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 8, 4, 4,  null) ]}
      addrDestP2PLocation          : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 8, 0, 4,  null) ]}
      addrDestP2PCarId             : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 9, 3, 5,  null) ]}
      addrDestP2PReserved          : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 9, 0, 3,  null) ]}
      addrDestP2PAudioSensorType   : BLonEnum     default{[ BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      addrDestP2MMaskUnit          : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 8, null) ]}
      addrDestP2MMaskCar           : BLonString   default{[ BLonString .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.st, 4, null) ]}
      addrDestP2MMaskLocation      : BLonString   default{[ BLonString .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.st, 2, null) ]}
      addrDestP2MMaskAudio         : BLonString   default{[ BLonString .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.st, 3, null) ]}
    }                               
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonRacCtrl(583071296)1.0$ @*/
/* Generated Thu Nov 09 17:21:56 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "audioLine"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>audioLine</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAudioLine
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAudioLine
   */
  public static final Property audioLine = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 0, 5, 3,  null) );
  
  /**
   * Get the <code>audioLine</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#audioLine
   */
  public BLonFloat getAudioLine() { return (BLonFloat)get(audioLine); }
  
  /**
   * Set the <code>audioLine</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#audioLine
   */
  public void setAudioLine(BLonFloat v) { set(audioLine,v,null); }

////////////////////////////////////////////////////////////////
// Property "duplexFull"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>duplexFull</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getDuplexFull
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setDuplexFull
   */
  public static final Property duplexFull = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 0, 4, 1,  null) );
  
  /**
   * Get the <code>duplexFull</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#duplexFull
   */
  public BLonBoolean getDuplexFull() { return (BLonBoolean)get(duplexFull); }
  
  /**
   * Set the <code>duplexFull</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#duplexFull
   */
  public void setDuplexFull(BLonBoolean v) { set(duplexFull,v,null); }

////////////////////////////////////////////////////////////////
// Property "destP2P"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>destP2P</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getDestP2P
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setDestP2P
   */
  public static final Property destP2P = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 0, 3, 1,  null) );
  
  /**
   * Get the <code>destP2P</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#destP2P
   */
  public BLonBoolean getDestP2P() { return (BLonBoolean)get(destP2P); }
  
  /**
   * Set the <code>destP2P</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#destP2P
   */
  public void setDestP2P(BLonBoolean v) { set(destP2P,v,null); }

////////////////////////////////////////////////////////////////
// Property "reserved"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>reserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getReserved
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setReserved
   */
  public static final Property reserved = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 0, 0, 3,  null) );
  
  /**
   * Get the <code>reserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#reserved
   */
  public BLonFloat getReserved() { return (BLonFloat)get(reserved); }
  
  /**
   * Set the <code>reserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#reserved
   */
  public void setReserved(BLonFloat v) { set(reserved,v,null); }

////////////////////////////////////////////////////////////////
// Property "audioType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>audioType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAudioType
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAudioType
   */
  public static final Property audioType = newProperty(0, BLonEnum.make(BLonRailAudioTypeEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>audioType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#audioType
   */
  public BLonEnum getAudioType() { return (BLonEnum)get(audioType); }
  
  /**
   * Set the <code>audioType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#audioType
   */
  public void setAudioType(BLonEnum v) { set(audioType,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitUnitId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrInitUnitId
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrInitUnitId
   */
  public static final Property addrInitUnitId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 8, 1F, 0F, true, 2, 4, false, 0F, 4, null) );
  
  /**
   * Get the <code>addrInitUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitUnitId
   */
  public BLonFloat getAddrInitUnitId() { return (BLonFloat)get(addrInitUnitId); }
  
  /**
   * Set the <code>addrInitUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitUnitId
   */
  public void setAddrInitUnitId(BLonFloat v) { set(addrInitUnitId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitLocation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrInitLocation
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrInitLocation
   */
  public static final Property addrInitLocation = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 2, 0, 4,  null) );
  
  /**
   * Get the <code>addrInitLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitLocation
   */
  public BLonFloat getAddrInitLocation() { return (BLonFloat)get(addrInitLocation); }
  
  /**
   * Set the <code>addrInitLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitLocation
   */
  public void setAddrInitLocation(BLonFloat v) { set(addrInitLocation,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitCarId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrInitCarId
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrInitCarId
   */
  public static final Property addrInitCarId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 3, 5,  null) );
  
  /**
   * Get the <code>addrInitCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitCarId
   */
  public BLonFloat getAddrInitCarId() { return (BLonFloat)get(addrInitCarId); }
  
  /**
   * Set the <code>addrInitCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitCarId
   */
  public void setAddrInitCarId(BLonFloat v) { set(addrInitCarId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitReserved"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrInitReserved
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrInitReserved
   */
  public static final Property addrInitReserved = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 3,  null) );
  
  /**
   * Get the <code>addrInitReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitReserved
   */
  public BLonFloat getAddrInitReserved() { return (BLonFloat)get(addrInitReserved); }
  
  /**
   * Set the <code>addrInitReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitReserved
   */
  public void setAddrInitReserved(BLonFloat v) { set(addrInitReserved,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrInitAudioSensorType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrInitAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrInitAudioSensorType
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrInitAudioSensorType
   */
  public static final Property addrInitAudioSensorType = newProperty(0, BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>addrInitAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitAudioSensorType
   */
  public BLonEnum getAddrInitAudioSensorType() { return (BLonEnum)get(addrInitAudioSensorType); }
  
  /**
   * Set the <code>addrInitAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrInitAudioSensorType
   */
  public void setAddrInitAudioSensorType(BLonEnum v) { set(addrInitAudioSensorType,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrTalkUnitId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrTalkUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrTalkUnitId
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrTalkUnitId
   */
  public static final Property addrTalkUnitId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 5, 4, 4,  null) );
  
  /**
   * Get the <code>addrTalkUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkUnitId
   */
  public BLonFloat getAddrTalkUnitId() { return (BLonFloat)get(addrTalkUnitId); }
  
  /**
   * Set the <code>addrTalkUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkUnitId
   */
  public void setAddrTalkUnitId(BLonFloat v) { set(addrTalkUnitId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrTalkLocation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrTalkLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrTalkLocation
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrTalkLocation
   */
  public static final Property addrTalkLocation = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 5, 0, 4,  null) );
  
  /**
   * Get the <code>addrTalkLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkLocation
   */
  public BLonFloat getAddrTalkLocation() { return (BLonFloat)get(addrTalkLocation); }
  
  /**
   * Set the <code>addrTalkLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkLocation
   */
  public void setAddrTalkLocation(BLonFloat v) { set(addrTalkLocation,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrTalkCarId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrTalkCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrTalkCarId
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrTalkCarId
   */
  public static final Property addrTalkCarId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 6, 3, 5,  null) );
  
  /**
   * Get the <code>addrTalkCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkCarId
   */
  public BLonFloat getAddrTalkCarId() { return (BLonFloat)get(addrTalkCarId); }
  
  /**
   * Set the <code>addrTalkCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkCarId
   */
  public void setAddrTalkCarId(BLonFloat v) { set(addrTalkCarId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrTalkReserved"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrTalkReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrTalkReserved
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrTalkReserved
   */
  public static final Property addrTalkReserved = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 6, 0, 3,  null) );
  
  /**
   * Get the <code>addrTalkReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkReserved
   */
  public BLonFloat getAddrTalkReserved() { return (BLonFloat)get(addrTalkReserved); }
  
  /**
   * Set the <code>addrTalkReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkReserved
   */
  public void setAddrTalkReserved(BLonFloat v) { set(addrTalkReserved,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrTalkAudioSensorType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrTalkAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrTalkAudioSensorType
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrTalkAudioSensorType
   */
  public static final Property addrTalkAudioSensorType = newProperty(0, BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>addrTalkAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkAudioSensorType
   */
  public BLonEnum getAddrTalkAudioSensorType() { return (BLonEnum)get(addrTalkAudioSensorType); }
  
  /**
   * Set the <code>addrTalkAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrTalkAudioSensorType
   */
  public void setAddrTalkAudioSensorType(BLonEnum v) { set(addrTalkAudioSensorType,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PUnitId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrDestP2PUnitId
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrDestP2PUnitId
   */
  public static final Property addrDestP2PUnitId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 8, 4, 4,  null) );
  
  /**
   * Get the <code>addrDestP2PUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PUnitId
   */
  public BLonFloat getAddrDestP2PUnitId() { return (BLonFloat)get(addrDestP2PUnitId); }
  
  /**
   * Set the <code>addrDestP2PUnitId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PUnitId
   */
  public void setAddrDestP2PUnitId(BLonFloat v) { set(addrDestP2PUnitId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PLocation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrDestP2PLocation
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrDestP2PLocation
   */
  public static final Property addrDestP2PLocation = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 8, 0, 4,  null) );
  
  /**
   * Get the <code>addrDestP2PLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PLocation
   */
  public BLonFloat getAddrDestP2PLocation() { return (BLonFloat)get(addrDestP2PLocation); }
  
  /**
   * Set the <code>addrDestP2PLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PLocation
   */
  public void setAddrDestP2PLocation(BLonFloat v) { set(addrDestP2PLocation,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PCarId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrDestP2PCarId
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrDestP2PCarId
   */
  public static final Property addrDestP2PCarId = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 9, 3, 5,  null) );
  
  /**
   * Get the <code>addrDestP2PCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PCarId
   */
  public BLonFloat getAddrDestP2PCarId() { return (BLonFloat)get(addrDestP2PCarId); }
  
  /**
   * Set the <code>addrDestP2PCarId</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PCarId
   */
  public void setAddrDestP2PCarId(BLonFloat v) { set(addrDestP2PCarId,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PReserved"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrDestP2PReserved
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrDestP2PReserved
   */
  public static final Property addrDestP2PReserved = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 9, 0, 3,  null) );
  
  /**
   * Get the <code>addrDestP2PReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PReserved
   */
  public BLonFloat getAddrDestP2PReserved() { return (BLonFloat)get(addrDestP2PReserved); }
  
  /**
   * Set the <code>addrDestP2PReserved</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PReserved
   */
  public void setAddrDestP2PReserved(BLonFloat v) { set(addrDestP2PReserved,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2PAudioSensorType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2PAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrDestP2PAudioSensorType
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrDestP2PAudioSensorType
   */
  public static final Property addrDestP2PAudioSensorType = newProperty(0, BLonEnum.make(BLonRailAudioSensorTypeEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>addrDestP2PAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PAudioSensorType
   */
  public BLonEnum getAddrDestP2PAudioSensorType() { return (BLonEnum)get(addrDestP2PAudioSensorType); }
  
  /**
   * Set the <code>addrDestP2PAudioSensorType</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2PAudioSensorType
   */
  public void setAddrDestP2PAudioSensorType(BLonEnum v) { set(addrDestP2PAudioSensorType,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2MMaskUnit"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2MMaskUnit</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrDestP2MMaskUnit
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrDestP2MMaskUnit
   */
  public static final Property addrDestP2MMaskUnit = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 8, null) );
  
  /**
   * Get the <code>addrDestP2MMaskUnit</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2MMaskUnit
   */
  public BLonFloat getAddrDestP2MMaskUnit() { return (BLonFloat)get(addrDestP2MMaskUnit); }
  
  /**
   * Set the <code>addrDestP2MMaskUnit</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2MMaskUnit
   */
  public void setAddrDestP2MMaskUnit(BLonFloat v) { set(addrDestP2MMaskUnit,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2MMaskCar"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2MMaskCar</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrDestP2MMaskCar
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrDestP2MMaskCar
   */
  public static final Property addrDestP2MMaskCar = newProperty(0, BLonString .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.st, 4, null) );
  
  /**
   * Get the <code>addrDestP2MMaskCar</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2MMaskCar
   */
  public BLonString getAddrDestP2MMaskCar() { return (BLonString)get(addrDestP2MMaskCar); }
  
  /**
   * Set the <code>addrDestP2MMaskCar</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2MMaskCar
   */
  public void setAddrDestP2MMaskCar(BLonString v) { set(addrDestP2MMaskCar,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2MMaskLocation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2MMaskLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrDestP2MMaskLocation
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrDestP2MMaskLocation
   */
  public static final Property addrDestP2MMaskLocation = newProperty(0, BLonString .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.st, 2, null) );
  
  /**
   * Get the <code>addrDestP2MMaskLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2MMaskLocation
   */
  public BLonString getAddrDestP2MMaskLocation() { return (BLonString)get(addrDestP2MMaskLocation); }
  
  /**
   * Set the <code>addrDestP2MMaskLocation</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2MMaskLocation
   */
  public void setAddrDestP2MMaskLocation(BLonString v) { set(addrDestP2MMaskLocation,v,null); }

////////////////////////////////////////////////////////////////
// Property "addrDestP2MMaskAudio"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addrDestP2MMaskAudio</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#getAddrDestP2MMaskAudio
   * @see javax.baja.lonworks.londata.BLonRacCtrl#setAddrDestP2MMaskAudio
   */
  public static final Property addrDestP2MMaskAudio = newProperty(0, BLonString .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.st, 3, null) );
  
  /**
   * Get the <code>addrDestP2MMaskAudio</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2MMaskAudio
   */
  public BLonString getAddrDestP2MMaskAudio() { return (BLonString)get(addrDestP2MMaskAudio); }
  
  /**
   * Set the <code>addrDestP2MMaskAudio</code> property.
   * @see javax.baja.lonworks.londata.BLonRacCtrl#addrDestP2MMaskAudio
   */
  public void setAddrDestP2MMaskAudio(BLonString v) { set(addrDestP2MMaskAudio,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonRacCtrl.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(audioLine                  , out);
    primitiveToOutputStream(duplexFull                 , out);
    primitiveToOutputStream(destP2P                    , out);
    primitiveToOutputStream(reserved                   , out);
    primitiveToOutputStream(audioType                  , out);
    primitiveToOutputStream(addrInitUnitId             , out);
    primitiveToOutputStream(addrInitLocation           , out);
    primitiveToOutputStream(addrInitCarId              , out);
    primitiveToOutputStream(addrInitReserved           , out);
    primitiveToOutputStream(addrInitAudioSensorType    , out);
    primitiveToOutputStream(addrTalkUnitId             , out);
    primitiveToOutputStream(addrTalkLocation           , out);
    primitiveToOutputStream(addrTalkCarId              , out);
    primitiveToOutputStream(addrTalkReserved           , out);
    primitiveToOutputStream(addrTalkAudioSensorType    , out);

    if(getDestP2P().getBoolean()) // This is just a quess - can't find any documentation
    {
      primitiveToOutputStream(addrDestP2PUnitId          , out);
      primitiveToOutputStream(addrDestP2PLocation        , out);
      primitiveToOutputStream(addrDestP2PCarId           , out);
      primitiveToOutputStream(addrDestP2PReserved        , out);
      primitiveToOutputStream(addrDestP2PAudioSensorType , out);
    }  
    else
    {
      primitiveToOutputStream(addrDestP2MMaskUnit      , out);
      primitiveToOutputStream(addrDestP2MMaskCar       , out);
      primitiveToOutputStream(addrDestP2MMaskLocation  , out);
      primitiveToOutputStream(addrDestP2MMaskAudio     , out);
    }  
  }
  
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(audioLine                  , in);
    primitiveFromInputStream(duplexFull                 , in);
    primitiveFromInputStream(destP2P                    , in);
    primitiveFromInputStream(reserved                   , in);
    primitiveFromInputStream(audioType                  , in);
    primitiveFromInputStream(addrInitUnitId             , in);
    primitiveFromInputStream(addrInitLocation           , in);
    primitiveFromInputStream(addrInitCarId              , in);
    primitiveFromInputStream(addrInitReserved           , in);
    primitiveFromInputStream(addrInitAudioSensorType    , in);
    primitiveFromInputStream(addrTalkUnitId             , in);
    primitiveFromInputStream(addrTalkLocation           , in);
    primitiveFromInputStream(addrTalkCarId              , in);
    primitiveFromInputStream(addrTalkReserved           , in);
    primitiveFromInputStream(addrTalkAudioSensorType    , in);
    
    if(getDestP2P().getBoolean())
    {
      primitiveFromInputStream(addrDestP2PUnitId          , in);
      primitiveFromInputStream(addrDestP2PLocation        , in);
      primitiveFromInputStream(addrDestP2PCarId           , in);
      primitiveFromInputStream(addrDestP2PReserved        , in);
      primitiveFromInputStream(addrDestP2PAudioSensorType , in);
    }
    else
    {
      primitiveFromInputStream(addrDestP2MMaskUnit        , in);
      primitiveFromInputStream(addrDestP2MMaskCar         , in);
      primitiveFromInputStream(addrDestP2MMaskLocation    , in);
      primitiveFromInputStream(addrDestP2MMaskAudio       , in);
    }
  }  


}      