/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonCamActEnum;
import javax.baja.lonworks.enums.BLonCamFuncEnum;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;


/**
 *   This class file represents SNVT_pos_ctrl.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  4 Sept 01
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:43 AM$
 * @since     Niagara 3.0
 */
public class BLonPosCtrl
  extends BLonData
{  
  /*
    <elem n="receiverId     " qual="u16"/>
    <elem n="controllerId   " qual="u16"/>
    <elem n="controllerPrio " qual="u8 max=100.0"/>
    <elem n="function       " qual="e8" enumDef="CamFuncT"/>
    <elem n="action         " qual="e8" enumDef="CamActT"/>
    <elem n="valueNumber    " qual="u8 byt=7"/>
    <elem n="valueAbsposPan " qual="ref type=AngleDeg byt=7"/>
    <elem n="valueAbsposTilt" qual="ref type=AngleDeg byt=9"/>
    <elem n="valueAbsposZoom" qual="ref type=LevPercent byt=11"/>

 <AngleDeg type="XTypeDef">
  <elem n="angleDeg" qual="s16 res=0.02 min=-359.97998 max=360.0 invld=32767.0" engUnit="degrees angular"/>
  <typeScope v="0,104"/>
 </AngleDeg>
 
 <LevPercent type="XTypeDef">
  <elem n="levPercent" qual="s16 res=0.0050 min=-163.84 max=163.83 invld=32767.0" engUnit="percent"/>
  <typeScope v="0,81"/>
 </LevPercent>

  */

  /*-

  class BLonPosCtrl
  {
    properties
    {
      receiverId      : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16, null) ]}
      controllerId    : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u16, null) ]}
      controllerPrio  : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 100, 1, null) ]}
      camFunction     : BLonEnum   default {[ BLonEnum.make(BLonCamFuncEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      camAction       : BLonEnum   default {[ BLonEnum.make(BLonCamActEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      valueNumber     : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.u8, 7) ]}
      valueAbsposPan  : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.s16, -359.97998F, 360.0F, 0.02F, 32767.0F, 7, 0, UnitDatabase.getUnit("degrees angular")) ]}
      valueAbsposTilt : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.s16, -359.97998F, 360.0F, 0.02F, 32767.0F, 9, 0, UnitDatabase.getUnit("degrees angular")) ]}
      valueAbsposZoom : BLonFloat  default{[ BLonFloat.DEFAULT ]}   slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.s16, -163.84F, 163.83F, 0.0050F, 32767.0F, 11, 0, UnitDatabase.getUnit("percent")) ]}
    }                               
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonPosCtrl(508955913)1.0$ @*/
/* Generated Wed Jan 27 16:28:24 EST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "receiverId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>receiverId</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#getReceiverId
   * @see javax.baja.lonworks.londata.BLonPosCtrl#setReceiverId
   */
  public static final Property receiverId = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16, null));
  
  /**
   * Get the <code>receiverId</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#receiverId
   */
  public BLonFloat getReceiverId() { return (BLonFloat)get(receiverId); }
  
  /**
   * Set the <code>receiverId</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#receiverId
   */
  public void setReceiverId(BLonFloat v) { set(receiverId,v,null); }

////////////////////////////////////////////////////////////////
// Property "controllerId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>controllerId</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#getControllerId
   * @see javax.baja.lonworks.londata.BLonPosCtrl#setControllerId
   */
  public static final Property controllerId = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u16, null));
  
  /**
   * Get the <code>controllerId</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#controllerId
   */
  public BLonFloat getControllerId() { return (BLonFloat)get(controllerId); }
  
  /**
   * Set the <code>controllerId</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#controllerId
   */
  public void setControllerId(BLonFloat v) { set(controllerId,v,null); }

////////////////////////////////////////////////////////////////
// Property "controllerPrio"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>controllerPrio</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#getControllerPrio
   * @see javax.baja.lonworks.londata.BLonPosCtrl#setControllerPrio
   */
  public static final Property controllerPrio = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 0, 100, 1, null));
  
  /**
   * Get the <code>controllerPrio</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#controllerPrio
   */
  public BLonFloat getControllerPrio() { return (BLonFloat)get(controllerPrio); }
  
  /**
   * Set the <code>controllerPrio</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#controllerPrio
   */
  public void setControllerPrio(BLonFloat v) { set(controllerPrio,v,null); }

////////////////////////////////////////////////////////////////
// Property "camFunction"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>camFunction</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#getCamFunction
   * @see javax.baja.lonworks.londata.BLonPosCtrl#setCamFunction
   */
  public static final Property camFunction = newProperty(0, BLonEnum.make(BLonCamFuncEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null));
  
  /**
   * Get the <code>camFunction</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#camFunction
   */
  public BLonEnum getCamFunction() { return (BLonEnum)get(camFunction); }
  
  /**
   * Set the <code>camFunction</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#camFunction
   */
  public void setCamFunction(BLonEnum v) { set(camFunction,v,null); }

////////////////////////////////////////////////////////////////
// Property "camAction"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>camAction</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#getCamAction
   * @see javax.baja.lonworks.londata.BLonPosCtrl#setCamAction
   */
  public static final Property camAction = newProperty(0, BLonEnum.make(BLonCamActEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null));
  
  /**
   * Get the <code>camAction</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#camAction
   */
  public BLonEnum getCamAction() { return (BLonEnum)get(camAction); }
  
  /**
   * Set the <code>camAction</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#camAction
   */
  public void setCamAction(BLonEnum v) { set(camAction,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueNumber"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueNumber</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#getValueNumber
   * @see javax.baja.lonworks.londata.BLonPosCtrl#setValueNumber
   */
  public static final Property valueNumber = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.u8, 7));
  
  /**
   * Get the <code>valueNumber</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#valueNumber
   */
  public BLonFloat getValueNumber() { return (BLonFloat)get(valueNumber); }
  
  /**
   * Set the <code>valueNumber</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#valueNumber
   */
  public void setValueNumber(BLonFloat v) { set(valueNumber,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueAbsposPan"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueAbsposPan</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#getValueAbsposPan
   * @see javax.baja.lonworks.londata.BLonPosCtrl#setValueAbsposPan
   */
  public static final Property valueAbsposPan = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.s16, -359.97998F, 360.0F, 0.02F, 32767.0F, 7, 0, UnitDatabase.getUnit("degrees angular")));
  
  /**
   * Get the <code>valueAbsposPan</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#valueAbsposPan
   */
  public BLonFloat getValueAbsposPan() { return (BLonFloat)get(valueAbsposPan); }
  
  /**
   * Set the <code>valueAbsposPan</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#valueAbsposPan
   */
  public void setValueAbsposPan(BLonFloat v) { set(valueAbsposPan,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueAbsposTilt"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueAbsposTilt</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#getValueAbsposTilt
   * @see javax.baja.lonworks.londata.BLonPosCtrl#setValueAbsposTilt
   */
  public static final Property valueAbsposTilt = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.s16, -359.97998F, 360.0F, 0.02F, 32767.0F, 9, 0, UnitDatabase.getUnit("degrees angular")));
  
  /**
   * Get the <code>valueAbsposTilt</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#valueAbsposTilt
   */
  public BLonFloat getValueAbsposTilt() { return (BLonFloat)get(valueAbsposTilt); }
  
  /**
   * Set the <code>valueAbsposTilt</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#valueAbsposTilt
   */
  public void setValueAbsposTilt(BLonFloat v) { set(valueAbsposTilt,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueAbsposZoom"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueAbsposZoom</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#getValueAbsposZoom
   * @see javax.baja.lonworks.londata.BLonPosCtrl#setValueAbsposZoom
   */
  public static final Property valueAbsposZoom = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.s16, -163.84F, 163.83F, 0.0050F, 32767.0F, 11, 0, UnitDatabase.getUnit("percent")));
  
  /**
   * Get the <code>valueAbsposZoom</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#valueAbsposZoom
   */
  public BLonFloat getValueAbsposZoom() { return (BLonFloat)get(valueAbsposZoom); }
  
  /**
   * Set the <code>valueAbsposZoom</code> property.
   * @see javax.baja.lonworks.londata.BLonPosCtrl#valueAbsposZoom
   */
  public void setValueAbsposZoom(BLonFloat v) { set(valueAbsposZoom,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonPosCtrl.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(receiverId      , out);
    primitiveToOutputStream(controllerId    , out);
    primitiveToOutputStream(controllerPrio  , out);
    primitiveToOutputStream(camFunction     , out);
    primitiveToOutputStream(camAction       , out);

    int f = getCamFunction().getEnum().getOrdinal();
    if(f == BLonCamFuncEnum.CMF_ABS)
    {
      primitiveToOutputStream(valueAbsposPan  , out);
      primitiveToOutputStream(valueAbsposTilt , out);
      primitiveToOutputStream(valueAbsposZoom , out);
    
    }  
    else
    {
      primitiveToOutputStream(valueNumber     , out);
      out.writeUnsigned8(0);
      out.writeUnsigned16(0);
      out.writeUnsigned16(0);
    }  
  }
  
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(receiverId     , in);
    primitiveFromInputStream(controllerId   , in);
    primitiveFromInputStream(controllerPrio , in);
    primitiveFromInputStream(camFunction    , in);
    primitiveFromInputStream(camAction      , in);
    
    int f = getCamFunction().getEnum().getOrdinal();
    if(f == BLonCamFuncEnum.CMF_ABS)
    {
      primitiveFromInputStream(valueAbsposPan , in);
      primitiveFromInputStream(valueAbsposTilt, in);
      primitiveFromInputStream(valueAbsposZoom, in);
    }
    else
    {
      primitiveFromInputStream(valueNumber    , in);
    }
  }  


}      