/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonDeviceSelectEnum;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file represents SNVT_dev_fault
 * <p>
 *  
 * @author    Robert Adams
 * @creation  4 Sept 01
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:43 AM$
 * @since     Niagara 3.0
 */
public class BLonDevFault
  extends BLonData
{  
  /*
 <DevFault type="XTypeDef">
  <elem n="deviceSelect" qual="e8" enumDef="DeviceSelectT"/>
  <elem n="pumpCtrlSfVoltageLow           "qual="ub byt=1 bit=7 len=1"/>
  <elem n="pumpCtrlSfVoltageHigh          "qual="ub byt=1 bit=6 len=1"/>
  <elem n="pumpCtrlSfPhase                "qual="ub byt=1 bit=5 len=1"/>
  <elem n="pumpCtrlSfNoFluid              "qual="ub byt=1 bit=4 len=1"/>
  <elem n="pumpCtrlSfPressLow             "qual="ub byt=1 bit=3 len=1"/>
  <elem n="pumpCtrlSfPressHigh            "qual="ub byt=1 bit=2 len=1"/>
  <elem n="pumpCtrlSfReserved16           "qual="ub byt=1 bit=1 len=1"/>
  <elem n="pumpCtrlSfReserved17           "qual="ub byt=1 bit=0 len=1"/>
  <elem n="pumpCtrlDfMotorTemp            "qual="ub byt=2 bit=7 len=1"/>
  <elem n="pumpCtrlDfMotorFailure         "qual="ub byt=2 bit=6 len=1"/>
  <elem n="pumpCtrlDfPumpBlocked          "qual="ub byt=2 bit=5 len=1"/>
  <elem n="pumpCtrlDfElectTemp            "qual="ub byt=2 bit=4 len=1"/>
  <elem n="pumpCtrlDfElectFailureNf       "qual="ub byt=2 bit=3 len=1"/>
  <elem n="pumpCtrlDfElectFailure         "qual="ub byt=2 bit=2 len=1"/>
  <elem n="pumpCtrlDfSensorFailure        "qual="ub byt=2 bit=1 len=1"/>
  <elem n="pumpCtrlDfReserved27           "qual="ub byt=2 bit=0 len=1"/>
  <elem n="pumpCtrlReserved307            "qual="ub byt=3 bit=0 len=8"/>
  <elem n="valvePosDfValveBlocked         "qual="ub byt=1 bit=7 len=1"/>
  <elem n="valvePosDfBlockedDirectionOpen "qual="ub byt=1 bit=6 len=1"/>
  <elem n="valvePosDfBlockedDirectionClose"qual="ub byt=1 bit=5 len=1"/>
  <elem n="valvePosDfPositionError        "qual="ub byt=1 bit=4 len=1"/>
  <elem n="valvePosDfStrokeOutOfRange     "qual="ub byt=1 bit=3 len=1"/>
  <elem n="valvePosDfInitialization       "qual="ub byt=1 bit=2 len=1"/>
  <elem n="valvePosDfVibrationCavitation  "qual="ub byt=1 bit=1 len=1"/>
  <elem n="valvePosDfEdTooHigh            "qual="ub byt=1 bit=0 len=1"/>
  <elem n="valvePosReserved102            "qual="ub byt=2 bit=5 len=3 max=1.0"/>
  <elem n="valvePosEeOscillating          "qual="ub byt=2 bit=4 len=1"/>
  <elem n="valvePosEeValveTooLarge        "qual="ub byt=2 bit=3 len=1"/>
  <elem n="valvePosEeValveTooSmall        "qual="ub byt=2 bit=2 len=1"/>
  <elem n="valvePosReserved267            "qual="ub byt=2 bit=0 len=2 max=1.0"/>
  <elem n="valvePosReserved307            "qual="ub byt=3 bit=7 len=1"/>
  <elem n="valvePosSfVoltageOutOfRange    "qual="ub byt=3 bit=6 len=1"/>
  <elem n="valvePosSfElectronicHighTemp   "qual="ub byt=3 bit=5 len=1"/>
  <elem n="valvePosSfFrictionalResistance "qual="ub byt=3 bit=4 len=1"/>
  <elem n="valvePosReserved446            "qual="ub byt=3 bit=1 len=3 max=1.0"/>
  <elem n="valvePosGeneralFault           "qual="ub byt=3 bit=0 len=1"/>
  <typeScope v="0,174"/>
 </DevFault>
  */

  /*-

  class BLonDevFault
  {
    properties
    {
      deviceSelect     : BLonEnum   default {[ BLonEnum.make(BLonDeviceSelectEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      pumpCtrlSfVoltageLow           : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) ]}
      pumpCtrlSfVoltageHigh          : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) ]}
      pumpCtrlSfPhase                : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) ]}
      pumpCtrlSfNoFluid              : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) ]}
      pumpCtrlSfPressLow             : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) ]}
      pumpCtrlSfPressHigh            : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) ]}
      pumpCtrlSfReserved16           : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 1, 1, null) ]}
      pumpCtrlSfReserved17           : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 0, 1, null) ]}
      pumpCtrlDfMotorTemp            : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 7, 1, null) ]}
      pumpCtrlDfMotorFailure         : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 6, 1, null) ]}
      pumpCtrlDfPumpBlocked          : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 5, 1, null) ]}
      pumpCtrlDfElectTemp            : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 4, 1, null) ]}
      pumpCtrlDfElectFailureNf       : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 3, 1, null) ]}
      pumpCtrlDfElectFailure         : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 2, 1, null) ]}
      pumpCtrlDfSensorFailure        : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 1, 1, null) ]}
      pumpCtrlDfReserved27           : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 0, 1, null) ]}
      pumpCtrlReserved307            : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 8, null) ]}
      valvePosDfValveBlocked         : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) ]}
      valvePosDfBlockedDirectionOpen : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) ]}
      valvePosDfBlockedDirectionClose: BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) ]}
      valvePosDfPositionError        : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) ]}
      valvePosDfStrokeOutOfRange     : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) ]}
      valvePosDfInitialization       : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) ]}
      valvePosDfVibrationCavitation  : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 1, 1, null) ]}
      valvePosDfEdTooHigh            : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 0, 1, null) ]}
      valvePosReserved102            : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 2, 5, false, 0F, 3, null ) ]}
      valvePosEeOscillating          : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 4, 1, null) ]}
      valvePosEeValveTooLarge        : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 3, 1, null) ]}
      valvePosEeValveTooSmall        : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 2, 1, null) ]}
      valvePosReserved267            : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 2, 0, false, 0F, 2, null ) ]}
      valvePosReserved307            : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 7, 1, null) ]}
      valvePosSfVoltageOutOfRange    : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 6, 1, null) ]}
      valvePosSfElectronicHighTemp   : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 5, 1, null) ]}
      valvePosSfFrictionalResistance : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 4, 1, null) ]}
      valvePosReserved446            : BLonFloat    default{[ BLonFloat.DEFAULT ]}    slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 3, 1, false, 0F,3, null ) ]}
      valvePosGeneralFault           : BLonBoolean  default{[ BLonBoolean.DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 0, 1, null) ]}
    }                               
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonDevFault(4230147269)1.0$ @*/
/* Generated Thu Nov 09 16:17:55 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "deviceSelect"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>deviceSelect</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getDeviceSelect
   * @see javax.baja.lonworks.londata.BLonDevFault#setDeviceSelect
   */
  public static final Property deviceSelect = newProperty(0, BLonEnum.make(BLonDeviceSelectEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>deviceSelect</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#deviceSelect
   */
  public BLonEnum getDeviceSelect() { return (BLonEnum)get(deviceSelect); }
  
  /**
   * Set the <code>deviceSelect</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#deviceSelect
   */
  public void setDeviceSelect(BLonEnum v) { set(deviceSelect,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSfVoltageLow"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSfVoltageLow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlSfVoltageLow
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlSfVoltageLow
   */
  public static final Property pumpCtrlSfVoltageLow = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSfVoltageLow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfVoltageLow
   */
  public BLonBoolean getPumpCtrlSfVoltageLow() { return (BLonBoolean)get(pumpCtrlSfVoltageLow); }
  
  /**
   * Set the <code>pumpCtrlSfVoltageLow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfVoltageLow
   */
  public void setPumpCtrlSfVoltageLow(BLonBoolean v) { set(pumpCtrlSfVoltageLow,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSfVoltageHigh"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSfVoltageHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlSfVoltageHigh
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlSfVoltageHigh
   */
  public static final Property pumpCtrlSfVoltageHigh = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSfVoltageHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfVoltageHigh
   */
  public BLonBoolean getPumpCtrlSfVoltageHigh() { return (BLonBoolean)get(pumpCtrlSfVoltageHigh); }
  
  /**
   * Set the <code>pumpCtrlSfVoltageHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfVoltageHigh
   */
  public void setPumpCtrlSfVoltageHigh(BLonBoolean v) { set(pumpCtrlSfVoltageHigh,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSfPhase"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSfPhase</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlSfPhase
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlSfPhase
   */
  public static final Property pumpCtrlSfPhase = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSfPhase</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfPhase
   */
  public BLonBoolean getPumpCtrlSfPhase() { return (BLonBoolean)get(pumpCtrlSfPhase); }
  
  /**
   * Set the <code>pumpCtrlSfPhase</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfPhase
   */
  public void setPumpCtrlSfPhase(BLonBoolean v) { set(pumpCtrlSfPhase,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSfNoFluid"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSfNoFluid</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlSfNoFluid
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlSfNoFluid
   */
  public static final Property pumpCtrlSfNoFluid = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSfNoFluid</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfNoFluid
   */
  public BLonBoolean getPumpCtrlSfNoFluid() { return (BLonBoolean)get(pumpCtrlSfNoFluid); }
  
  /**
   * Set the <code>pumpCtrlSfNoFluid</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfNoFluid
   */
  public void setPumpCtrlSfNoFluid(BLonBoolean v) { set(pumpCtrlSfNoFluid,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSfPressLow"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSfPressLow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlSfPressLow
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlSfPressLow
   */
  public static final Property pumpCtrlSfPressLow = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSfPressLow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfPressLow
   */
  public BLonBoolean getPumpCtrlSfPressLow() { return (BLonBoolean)get(pumpCtrlSfPressLow); }
  
  /**
   * Set the <code>pumpCtrlSfPressLow</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfPressLow
   */
  public void setPumpCtrlSfPressLow(BLonBoolean v) { set(pumpCtrlSfPressLow,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSfPressHigh"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSfPressHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlSfPressHigh
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlSfPressHigh
   */
  public static final Property pumpCtrlSfPressHigh = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSfPressHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfPressHigh
   */
  public BLonBoolean getPumpCtrlSfPressHigh() { return (BLonBoolean)get(pumpCtrlSfPressHigh); }
  
  /**
   * Set the <code>pumpCtrlSfPressHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfPressHigh
   */
  public void setPumpCtrlSfPressHigh(BLonBoolean v) { set(pumpCtrlSfPressHigh,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSfReserved16"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSfReserved16</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlSfReserved16
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlSfReserved16
   */
  public static final Property pumpCtrlSfReserved16 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 1, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSfReserved16</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfReserved16
   */
  public BLonBoolean getPumpCtrlSfReserved16() { return (BLonBoolean)get(pumpCtrlSfReserved16); }
  
  /**
   * Set the <code>pumpCtrlSfReserved16</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfReserved16
   */
  public void setPumpCtrlSfReserved16(BLonBoolean v) { set(pumpCtrlSfReserved16,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlSfReserved17"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlSfReserved17</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlSfReserved17
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlSfReserved17
   */
  public static final Property pumpCtrlSfReserved17 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 0, 1, null) );
  
  /**
   * Get the <code>pumpCtrlSfReserved17</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfReserved17
   */
  public BLonBoolean getPumpCtrlSfReserved17() { return (BLonBoolean)get(pumpCtrlSfReserved17); }
  
  /**
   * Set the <code>pumpCtrlSfReserved17</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlSfReserved17
   */
  public void setPumpCtrlSfReserved17(BLonBoolean v) { set(pumpCtrlSfReserved17,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlDfMotorTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlDfMotorTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlDfMotorTemp
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlDfMotorTemp
   */
  public static final Property pumpCtrlDfMotorTemp = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 7, 1, null) );
  
  /**
   * Get the <code>pumpCtrlDfMotorTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfMotorTemp
   */
  public BLonBoolean getPumpCtrlDfMotorTemp() { return (BLonBoolean)get(pumpCtrlDfMotorTemp); }
  
  /**
   * Set the <code>pumpCtrlDfMotorTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfMotorTemp
   */
  public void setPumpCtrlDfMotorTemp(BLonBoolean v) { set(pumpCtrlDfMotorTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlDfMotorFailure"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlDfMotorFailure</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlDfMotorFailure
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlDfMotorFailure
   */
  public static final Property pumpCtrlDfMotorFailure = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 6, 1, null) );
  
  /**
   * Get the <code>pumpCtrlDfMotorFailure</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfMotorFailure
   */
  public BLonBoolean getPumpCtrlDfMotorFailure() { return (BLonBoolean)get(pumpCtrlDfMotorFailure); }
  
  /**
   * Set the <code>pumpCtrlDfMotorFailure</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfMotorFailure
   */
  public void setPumpCtrlDfMotorFailure(BLonBoolean v) { set(pumpCtrlDfMotorFailure,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlDfPumpBlocked"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlDfPumpBlocked</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlDfPumpBlocked
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlDfPumpBlocked
   */
  public static final Property pumpCtrlDfPumpBlocked = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 5, 1, null) );
  
  /**
   * Get the <code>pumpCtrlDfPumpBlocked</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfPumpBlocked
   */
  public BLonBoolean getPumpCtrlDfPumpBlocked() { return (BLonBoolean)get(pumpCtrlDfPumpBlocked); }
  
  /**
   * Set the <code>pumpCtrlDfPumpBlocked</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfPumpBlocked
   */
  public void setPumpCtrlDfPumpBlocked(BLonBoolean v) { set(pumpCtrlDfPumpBlocked,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlDfElectTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlDfElectTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlDfElectTemp
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlDfElectTemp
   */
  public static final Property pumpCtrlDfElectTemp = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 4, 1, null) );
  
  /**
   * Get the <code>pumpCtrlDfElectTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfElectTemp
   */
  public BLonBoolean getPumpCtrlDfElectTemp() { return (BLonBoolean)get(pumpCtrlDfElectTemp); }
  
  /**
   * Set the <code>pumpCtrlDfElectTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfElectTemp
   */
  public void setPumpCtrlDfElectTemp(BLonBoolean v) { set(pumpCtrlDfElectTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlDfElectFailureNf"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlDfElectFailureNf</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlDfElectFailureNf
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlDfElectFailureNf
   */
  public static final Property pumpCtrlDfElectFailureNf = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 3, 1, null) );
  
  /**
   * Get the <code>pumpCtrlDfElectFailureNf</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfElectFailureNf
   */
  public BLonBoolean getPumpCtrlDfElectFailureNf() { return (BLonBoolean)get(pumpCtrlDfElectFailureNf); }
  
  /**
   * Set the <code>pumpCtrlDfElectFailureNf</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfElectFailureNf
   */
  public void setPumpCtrlDfElectFailureNf(BLonBoolean v) { set(pumpCtrlDfElectFailureNf,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlDfElectFailure"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlDfElectFailure</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlDfElectFailure
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlDfElectFailure
   */
  public static final Property pumpCtrlDfElectFailure = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 2, 1, null) );
  
  /**
   * Get the <code>pumpCtrlDfElectFailure</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfElectFailure
   */
  public BLonBoolean getPumpCtrlDfElectFailure() { return (BLonBoolean)get(pumpCtrlDfElectFailure); }
  
  /**
   * Set the <code>pumpCtrlDfElectFailure</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfElectFailure
   */
  public void setPumpCtrlDfElectFailure(BLonBoolean v) { set(pumpCtrlDfElectFailure,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlDfSensorFailure"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlDfSensorFailure</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlDfSensorFailure
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlDfSensorFailure
   */
  public static final Property pumpCtrlDfSensorFailure = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 1, 1, null) );
  
  /**
   * Get the <code>pumpCtrlDfSensorFailure</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfSensorFailure
   */
  public BLonBoolean getPumpCtrlDfSensorFailure() { return (BLonBoolean)get(pumpCtrlDfSensorFailure); }
  
  /**
   * Set the <code>pumpCtrlDfSensorFailure</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfSensorFailure
   */
  public void setPumpCtrlDfSensorFailure(BLonBoolean v) { set(pumpCtrlDfSensorFailure,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlDfReserved27"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlDfReserved27</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlDfReserved27
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlDfReserved27
   */
  public static final Property pumpCtrlDfReserved27 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 0, 1, null) );
  
  /**
   * Get the <code>pumpCtrlDfReserved27</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfReserved27
   */
  public BLonBoolean getPumpCtrlDfReserved27() { return (BLonBoolean)get(pumpCtrlDfReserved27); }
  
  /**
   * Set the <code>pumpCtrlDfReserved27</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlDfReserved27
   */
  public void setPumpCtrlDfReserved27(BLonBoolean v) { set(pumpCtrlDfReserved27,v,null); }

////////////////////////////////////////////////////////////////
// Property "pumpCtrlReserved307"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pumpCtrlReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getPumpCtrlReserved307
   * @see javax.baja.lonworks.londata.BLonDevFault#setPumpCtrlReserved307
   */
  public static final Property pumpCtrlReserved307 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 3, 0, 8, null) );
  
  /**
   * Get the <code>pumpCtrlReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlReserved307
   */
  public BLonFloat getPumpCtrlReserved307() { return (BLonFloat)get(pumpCtrlReserved307); }
  
  /**
   * Set the <code>pumpCtrlReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#pumpCtrlReserved307
   */
  public void setPumpCtrlReserved307(BLonFloat v) { set(pumpCtrlReserved307,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosDfValveBlocked"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosDfValveBlocked</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosDfValveBlocked
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosDfValveBlocked
   */
  public static final Property valvePosDfValveBlocked = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 7, 1, null) );
  
  /**
   * Get the <code>valvePosDfValveBlocked</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfValveBlocked
   */
  public BLonBoolean getValvePosDfValveBlocked() { return (BLonBoolean)get(valvePosDfValveBlocked); }
  
  /**
   * Set the <code>valvePosDfValveBlocked</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfValveBlocked
   */
  public void setValvePosDfValveBlocked(BLonBoolean v) { set(valvePosDfValveBlocked,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosDfBlockedDirectionOpen"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosDfBlockedDirectionOpen</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosDfBlockedDirectionOpen
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosDfBlockedDirectionOpen
   */
  public static final Property valvePosDfBlockedDirectionOpen = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 6, 1, null) );
  
  /**
   * Get the <code>valvePosDfBlockedDirectionOpen</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfBlockedDirectionOpen
   */
  public BLonBoolean getValvePosDfBlockedDirectionOpen() { return (BLonBoolean)get(valvePosDfBlockedDirectionOpen); }
  
  /**
   * Set the <code>valvePosDfBlockedDirectionOpen</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfBlockedDirectionOpen
   */
  public void setValvePosDfBlockedDirectionOpen(BLonBoolean v) { set(valvePosDfBlockedDirectionOpen,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosDfBlockedDirectionClose"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosDfBlockedDirectionClose</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosDfBlockedDirectionClose
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosDfBlockedDirectionClose
   */
  public static final Property valvePosDfBlockedDirectionClose = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 5, 1, null) );
  
  /**
   * Get the <code>valvePosDfBlockedDirectionClose</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfBlockedDirectionClose
   */
  public BLonBoolean getValvePosDfBlockedDirectionClose() { return (BLonBoolean)get(valvePosDfBlockedDirectionClose); }
  
  /**
   * Set the <code>valvePosDfBlockedDirectionClose</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfBlockedDirectionClose
   */
  public void setValvePosDfBlockedDirectionClose(BLonBoolean v) { set(valvePosDfBlockedDirectionClose,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosDfPositionError"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosDfPositionError</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosDfPositionError
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosDfPositionError
   */
  public static final Property valvePosDfPositionError = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 4, 1, null) );
  
  /**
   * Get the <code>valvePosDfPositionError</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfPositionError
   */
  public BLonBoolean getValvePosDfPositionError() { return (BLonBoolean)get(valvePosDfPositionError); }
  
  /**
   * Set the <code>valvePosDfPositionError</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfPositionError
   */
  public void setValvePosDfPositionError(BLonBoolean v) { set(valvePosDfPositionError,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosDfStrokeOutOfRange"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosDfStrokeOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosDfStrokeOutOfRange
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosDfStrokeOutOfRange
   */
  public static final Property valvePosDfStrokeOutOfRange = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 3, 1, null) );
  
  /**
   * Get the <code>valvePosDfStrokeOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfStrokeOutOfRange
   */
  public BLonBoolean getValvePosDfStrokeOutOfRange() { return (BLonBoolean)get(valvePosDfStrokeOutOfRange); }
  
  /**
   * Set the <code>valvePosDfStrokeOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfStrokeOutOfRange
   */
  public void setValvePosDfStrokeOutOfRange(BLonBoolean v) { set(valvePosDfStrokeOutOfRange,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosDfInitialization"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosDfInitialization</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosDfInitialization
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosDfInitialization
   */
  public static final Property valvePosDfInitialization = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 2, 1, null) );
  
  /**
   * Get the <code>valvePosDfInitialization</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfInitialization
   */
  public BLonBoolean getValvePosDfInitialization() { return (BLonBoolean)get(valvePosDfInitialization); }
  
  /**
   * Set the <code>valvePosDfInitialization</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfInitialization
   */
  public void setValvePosDfInitialization(BLonBoolean v) { set(valvePosDfInitialization,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosDfVibrationCavitation"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosDfVibrationCavitation</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosDfVibrationCavitation
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosDfVibrationCavitation
   */
  public static final Property valvePosDfVibrationCavitation = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 1, 1, null) );
  
  /**
   * Get the <code>valvePosDfVibrationCavitation</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfVibrationCavitation
   */
  public BLonBoolean getValvePosDfVibrationCavitation() { return (BLonBoolean)get(valvePosDfVibrationCavitation); }
  
  /**
   * Set the <code>valvePosDfVibrationCavitation</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfVibrationCavitation
   */
  public void setValvePosDfVibrationCavitation(BLonBoolean v) { set(valvePosDfVibrationCavitation,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosDfEdTooHigh"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosDfEdTooHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosDfEdTooHigh
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosDfEdTooHigh
   */
  public static final Property valvePosDfEdTooHigh = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 1, 0, 1, null) );
  
  /**
   * Get the <code>valvePosDfEdTooHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfEdTooHigh
   */
  public BLonBoolean getValvePosDfEdTooHigh() { return (BLonBoolean)get(valvePosDfEdTooHigh); }
  
  /**
   * Set the <code>valvePosDfEdTooHigh</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosDfEdTooHigh
   */
  public void setValvePosDfEdTooHigh(BLonBoolean v) { set(valvePosDfEdTooHigh,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved102"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved102</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosReserved102
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosReserved102
   */
  public static final Property valvePosReserved102 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 2, 5, false, 0F, 3, null ) );
  
  /**
   * Get the <code>valvePosReserved102</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosReserved102
   */
  public BLonFloat getValvePosReserved102() { return (BLonFloat)get(valvePosReserved102); }
  
  /**
   * Set the <code>valvePosReserved102</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosReserved102
   */
  public void setValvePosReserved102(BLonFloat v) { set(valvePosReserved102,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosEeOscillating"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosEeOscillating</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosEeOscillating
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosEeOscillating
   */
  public static final Property valvePosEeOscillating = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 4, 1, null) );
  
  /**
   * Get the <code>valvePosEeOscillating</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosEeOscillating
   */
  public BLonBoolean getValvePosEeOscillating() { return (BLonBoolean)get(valvePosEeOscillating); }
  
  /**
   * Set the <code>valvePosEeOscillating</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosEeOscillating
   */
  public void setValvePosEeOscillating(BLonBoolean v) { set(valvePosEeOscillating,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosEeValveTooLarge"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosEeValveTooLarge</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosEeValveTooLarge
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosEeValveTooLarge
   */
  public static final Property valvePosEeValveTooLarge = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 3, 1, null) );
  
  /**
   * Get the <code>valvePosEeValveTooLarge</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosEeValveTooLarge
   */
  public BLonBoolean getValvePosEeValveTooLarge() { return (BLonBoolean)get(valvePosEeValveTooLarge); }
  
  /**
   * Set the <code>valvePosEeValveTooLarge</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosEeValveTooLarge
   */
  public void setValvePosEeValveTooLarge(BLonBoolean v) { set(valvePosEeValveTooLarge,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosEeValveTooSmall"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosEeValveTooSmall</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosEeValveTooSmall
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosEeValveTooSmall
   */
  public static final Property valvePosEeValveTooSmall = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 2, 2, 1, null) );
  
  /**
   * Get the <code>valvePosEeValveTooSmall</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosEeValveTooSmall
   */
  public BLonBoolean getValvePosEeValveTooSmall() { return (BLonBoolean)get(valvePosEeValveTooSmall); }
  
  /**
   * Set the <code>valvePosEeValveTooSmall</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosEeValveTooSmall
   */
  public void setValvePosEeValveTooSmall(BLonBoolean v) { set(valvePosEeValveTooSmall,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved267"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved267</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosReserved267
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosReserved267
   */
  public static final Property valvePosReserved267 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 2, 0, false, 0F, 2, null ) );
  
  /**
   * Get the <code>valvePosReserved267</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosReserved267
   */
  public BLonFloat getValvePosReserved267() { return (BLonFloat)get(valvePosReserved267); }
  
  /**
   * Set the <code>valvePosReserved267</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosReserved267
   */
  public void setValvePosReserved267(BLonFloat v) { set(valvePosReserved267,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved307"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosReserved307
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosReserved307
   */
  public static final Property valvePosReserved307 = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 7, 1, null) );
  
  /**
   * Get the <code>valvePosReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosReserved307
   */
  public BLonBoolean getValvePosReserved307() { return (BLonBoolean)get(valvePosReserved307); }
  
  /**
   * Set the <code>valvePosReserved307</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosReserved307
   */
  public void setValvePosReserved307(BLonBoolean v) { set(valvePosReserved307,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosSfVoltageOutOfRange"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosSfVoltageOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosSfVoltageOutOfRange
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosSfVoltageOutOfRange
   */
  public static final Property valvePosSfVoltageOutOfRange = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 6, 1, null) );
  
  /**
   * Get the <code>valvePosSfVoltageOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosSfVoltageOutOfRange
   */
  public BLonBoolean getValvePosSfVoltageOutOfRange() { return (BLonBoolean)get(valvePosSfVoltageOutOfRange); }
  
  /**
   * Set the <code>valvePosSfVoltageOutOfRange</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosSfVoltageOutOfRange
   */
  public void setValvePosSfVoltageOutOfRange(BLonBoolean v) { set(valvePosSfVoltageOutOfRange,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosSfElectronicHighTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosSfElectronicHighTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosSfElectronicHighTemp
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosSfElectronicHighTemp
   */
  public static final Property valvePosSfElectronicHighTemp = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 5, 1, null) );
  
  /**
   * Get the <code>valvePosSfElectronicHighTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosSfElectronicHighTemp
   */
  public BLonBoolean getValvePosSfElectronicHighTemp() { return (BLonBoolean)get(valvePosSfElectronicHighTemp); }
  
  /**
   * Set the <code>valvePosSfElectronicHighTemp</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosSfElectronicHighTemp
   */
  public void setValvePosSfElectronicHighTemp(BLonBoolean v) { set(valvePosSfElectronicHighTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosSfFrictionalResistance"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosSfFrictionalResistance</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosSfFrictionalResistance
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosSfFrictionalResistance
   */
  public static final Property valvePosSfFrictionalResistance = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 4, 1, null) );
  
  /**
   * Get the <code>valvePosSfFrictionalResistance</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosSfFrictionalResistance
   */
  public BLonBoolean getValvePosSfFrictionalResistance() { return (BLonBoolean)get(valvePosSfFrictionalResistance); }
  
  /**
   * Set the <code>valvePosSfFrictionalResistance</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosSfFrictionalResistance
   */
  public void setValvePosSfFrictionalResistance(BLonBoolean v) { set(valvePosSfFrictionalResistance,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosReserved446"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosReserved446</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosReserved446
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosReserved446
   */
  public static final Property valvePosReserved446 = newProperty(0, BLonFloat.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, false, 0F,true, 1, 1F, 0F, true, 3, 1, false, 0F,3, null ) );
  
  /**
   * Get the <code>valvePosReserved446</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosReserved446
   */
  public BLonFloat getValvePosReserved446() { return (BLonFloat)get(valvePosReserved446); }
  
  /**
   * Set the <code>valvePosReserved446</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosReserved446
   */
  public void setValvePosReserved446(BLonFloat v) { set(valvePosReserved446,v,null); }

////////////////////////////////////////////////////////////////
// Property "valvePosGeneralFault"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valvePosGeneralFault</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#getValvePosGeneralFault
   * @see javax.baja.lonworks.londata.BLonDevFault#setValvePosGeneralFault
   */
  public static final Property valvePosGeneralFault = newProperty(0, BLonBoolean.DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.bb, 3, 0, 1, null) );
  
  /**
   * Get the <code>valvePosGeneralFault</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosGeneralFault
   */
  public BLonBoolean getValvePosGeneralFault() { return (BLonBoolean)get(valvePosGeneralFault); }
  
  /**
   * Set the <code>valvePosGeneralFault</code> property.
   * @see javax.baja.lonworks.londata.BLonDevFault#valvePosGeneralFault
   */
  public void setValvePosGeneralFault(BLonBoolean v) { set(valvePosGeneralFault,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonDevFault.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
   
  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(deviceSelect      , out);

    int f = getDeviceSelect().getEnum().getOrdinal();
    if(f == BLonDeviceSelectEnum.DV_PUMP_CTRL)
    {
      primitiveToOutputStream(pumpCtrlSfVoltageLow      , out);
      primitiveToOutputStream(pumpCtrlSfVoltageHigh     , out);
      primitiveToOutputStream(pumpCtrlSfPhase           , out);
      primitiveToOutputStream(pumpCtrlSfNoFluid         , out);
      primitiveToOutputStream(pumpCtrlSfPressLow        , out);
      primitiveToOutputStream(pumpCtrlSfPressHigh       , out);
      primitiveToOutputStream(pumpCtrlSfReserved16      , out);
      primitiveToOutputStream(pumpCtrlSfReserved17      , out);
      primitiveToOutputStream(pumpCtrlDfMotorTemp       , out);
      primitiveToOutputStream(pumpCtrlDfMotorFailure    , out);
      primitiveToOutputStream(pumpCtrlDfPumpBlocked     , out);
      primitiveToOutputStream(pumpCtrlDfElectTemp       , out);
      primitiveToOutputStream(pumpCtrlDfElectFailureNf  , out);
      primitiveToOutputStream(pumpCtrlDfElectFailure    , out);
      primitiveToOutputStream(pumpCtrlDfSensorFailure   , out);
      primitiveToOutputStream(pumpCtrlDfReserved27      , out);
      primitiveToOutputStream(pumpCtrlReserved307       , out);
    }  
    else
    {
      primitiveToOutputStream(valvePosDfValveBlocked            , out);
      primitiveToOutputStream(valvePosDfBlockedDirectionOpen    , out);
      primitiveToOutputStream(valvePosDfBlockedDirectionClose   , out);
      primitiveToOutputStream(valvePosDfPositionError           , out);
      primitiveToOutputStream(valvePosDfStrokeOutOfRange        , out);
      primitiveToOutputStream(valvePosDfInitialization          , out);
      primitiveToOutputStream(valvePosDfVibrationCavitation     , out);
      primitiveToOutputStream(valvePosDfEdTooHigh               , out);
      primitiveToOutputStream(valvePosReserved102               , out);
      primitiveToOutputStream(valvePosEeOscillating             , out);
      primitiveToOutputStream(valvePosEeValveTooLarge           , out);
      primitiveToOutputStream(valvePosEeValveTooSmall           , out);
      primitiveToOutputStream(valvePosReserved267               , out);
      primitiveToOutputStream(valvePosReserved307               , out);
      primitiveToOutputStream(valvePosSfVoltageOutOfRange       , out);
      primitiveToOutputStream(valvePosSfElectronicHighTemp      , out);
      primitiveToOutputStream(valvePosSfFrictionalResistance    , out);
      primitiveToOutputStream(valvePosReserved446               , out);
      primitiveToOutputStream(valvePosGeneralFault              , out);
    }  
  }
  
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(deviceSelect     , in);
    
    int f = getDeviceSelect().getEnum().getOrdinal();
    if(f == BLonDeviceSelectEnum.DV_PUMP_CTRL)
    {
      primitiveFromInputStream(pumpCtrlSfVoltageLow      , in);
      primitiveFromInputStream(pumpCtrlSfVoltageHigh     , in);
      primitiveFromInputStream(pumpCtrlSfPhase           , in);
      primitiveFromInputStream(pumpCtrlSfNoFluid         , in);
      primitiveFromInputStream(pumpCtrlSfPressLow        , in);
      primitiveFromInputStream(pumpCtrlSfPressHigh       , in);
      primitiveFromInputStream(pumpCtrlSfReserved16      , in);
      primitiveFromInputStream(pumpCtrlSfReserved17      , in);
      primitiveFromInputStream(pumpCtrlDfMotorTemp       , in);
      primitiveFromInputStream(pumpCtrlDfMotorFailure    , in);
      primitiveFromInputStream(pumpCtrlDfPumpBlocked     , in);
      primitiveFromInputStream(pumpCtrlDfElectTemp       , in);
      primitiveFromInputStream(pumpCtrlDfElectFailureNf  , in);
      primitiveFromInputStream(pumpCtrlDfElectFailure    , in);
      primitiveFromInputStream(pumpCtrlDfSensorFailure   , in);
      primitiveFromInputStream(pumpCtrlDfReserved27      , in);
      primitiveFromInputStream(pumpCtrlReserved307       , in);
    }
    else
    {
      primitiveFromInputStream(valvePosDfValveBlocked             , in);
      primitiveFromInputStream(valvePosDfBlockedDirectionOpen     , in);
      primitiveFromInputStream(valvePosDfBlockedDirectionClose    , in);
      primitiveFromInputStream(valvePosDfPositionError            , in);
      primitiveFromInputStream(valvePosDfStrokeOutOfRange         , in);
      primitiveFromInputStream(valvePosDfInitialization           , in);
      primitiveFromInputStream(valvePosDfVibrationCavitation      , in);
      primitiveFromInputStream(valvePosDfEdTooHigh                , in);
      primitiveFromInputStream(valvePosReserved102                , in);
      primitiveFromInputStream(valvePosEeOscillating              , in);
      primitiveFromInputStream(valvePosEeValveTooLarge            , in);
      primitiveFromInputStream(valvePosEeValveTooSmall            , in);
      primitiveFromInputStream(valvePosReserved267                , in);
      primitiveFromInputStream(valvePosReserved307                , in);
      primitiveFromInputStream(valvePosSfVoltageOutOfRange        , in);
      primitiveFromInputStream(valvePosSfElectronicHighTemp       , in);
      primitiveFromInputStream(valvePosSfFrictionalResistance     , in);
      primitiveFromInputStream(valvePosReserved446                , in);
      primitiveFromInputStream(valvePosGeneralFault               , in);
    }
  }  


}      