/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;

import javax.baja.lonworks.enums.BLonDaysOfWeekEnum;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.enums.BLonIntervalOfMonthEnum;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file represents SCPT_time_period.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  10 Nov 06
 * @version   $Revision: 3$ $Date: 9/28/01 10:20:43 AM$
 * @since     Niagara 3.0
 */
public class BLonCpTimePeriod
  extends BLonData
{  
  /*
 <CpTimePeriod type="XCpTypeDef">
  <init v="00 00"/>
  <elem n="units                " qual="e8" enumDef="IntervalOfMonthT"/>
  <elem n="valueMinutesInterval " qual="u8 byt=1 min=1.0"/>
  <elem n="valueDateOfMonth     " qual="u8 byt=1 min=1.0 max=31.0"/>
  <elem n="valueHourOfDay       " qual="u8 byt=1 max=23.0"/>
  <elem n="valueDayOfWeek       " qual="e8" enumDef="DaysOfWeekT"/>
  <elem n="valueHoursInterval   " qual="u8 byt=1 min=1.0"/>
  <typeScope v="0,291"/>
 </CpTimePeriod>
 */

  /*-

  class BLonCpTimePeriod
  {
    properties
    {
      units                 : BLonEnum     default{[ BLonEnum.make(BLonIntervalOfMonthEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      valueMinutesInterval  : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 1.0F, null) ]}
      valueDateOfMonth      : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 1.0F, 31.0F, 1.0F, null) ]}
      valueHourOfDay        : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 0.0F, 23.0F, 1.0F, null) ]}
      valueDayOfWeek        : BLonEnum     default{[ BLonEnum.make(BLonDaysOfWeekEnum.DEFAULT) ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.e8, null) ]}
      valueHoursInterval    : BLonFloat    default{[ BLonFloat  .DEFAULT ]}  slotfacets {[ LonFacetsUtil.makeFacets(BLonElementType.ub, 1.0F, null) ]}
    }                               
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.londata.BLonCpTimePeriod(2749276318)1.0$ @*/
/* Generated Fri Nov 10 10:01:09 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "units"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>units</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#getUnits
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#setUnits
   */
  public static final Property units = newProperty(0, BLonEnum.make(BLonIntervalOfMonthEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>units</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#units
   */
  public BLonEnum getUnits() { return (BLonEnum)get(units); }
  
  /**
   * Set the <code>units</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#units
   */
  public void setUnits(BLonEnum v) { set(units,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueMinutesInterval"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueMinutesInterval</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#getValueMinutesInterval
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#setValueMinutesInterval
   */
  public static final Property valueMinutesInterval = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 1.0F, null) );
  
  /**
   * Get the <code>valueMinutesInterval</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueMinutesInterval
   */
  public BLonFloat getValueMinutesInterval() { return (BLonFloat)get(valueMinutesInterval); }
  
  /**
   * Set the <code>valueMinutesInterval</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueMinutesInterval
   */
  public void setValueMinutesInterval(BLonFloat v) { set(valueMinutesInterval,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueDateOfMonth"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueDateOfMonth</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#getValueDateOfMonth
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#setValueDateOfMonth
   */
  public static final Property valueDateOfMonth = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 1.0F, 31.0F, 1.0F, null) );
  
  /**
   * Get the <code>valueDateOfMonth</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueDateOfMonth
   */
  public BLonFloat getValueDateOfMonth() { return (BLonFloat)get(valueDateOfMonth); }
  
  /**
   * Set the <code>valueDateOfMonth</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueDateOfMonth
   */
  public void setValueDateOfMonth(BLonFloat v) { set(valueDateOfMonth,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueHourOfDay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueHourOfDay</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#getValueHourOfDay
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#setValueHourOfDay
   */
  public static final Property valueHourOfDay = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 0.0F, 23.0F, 1.0F, null) );
  
  /**
   * Get the <code>valueHourOfDay</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueHourOfDay
   */
  public BLonFloat getValueHourOfDay() { return (BLonFloat)get(valueHourOfDay); }
  
  /**
   * Set the <code>valueHourOfDay</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueHourOfDay
   */
  public void setValueHourOfDay(BLonFloat v) { set(valueHourOfDay,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueDayOfWeek"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueDayOfWeek</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#getValueDayOfWeek
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#setValueDayOfWeek
   */
  public static final Property valueDayOfWeek = newProperty(0, BLonEnum.make(BLonDaysOfWeekEnum.DEFAULT),LonFacetsUtil.makeFacets(BLonElementType.e8, null) );
  
  /**
   * Get the <code>valueDayOfWeek</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueDayOfWeek
   */
  public BLonEnum getValueDayOfWeek() { return (BLonEnum)get(valueDayOfWeek); }
  
  /**
   * Set the <code>valueDayOfWeek</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueDayOfWeek
   */
  public void setValueDayOfWeek(BLonEnum v) { set(valueDayOfWeek,v,null); }

////////////////////////////////////////////////////////////////
// Property "valueHoursInterval"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>valueHoursInterval</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#getValueHoursInterval
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#setValueHoursInterval
   */
  public static final Property valueHoursInterval = newProperty(0, BLonFloat  .DEFAULT,LonFacetsUtil.makeFacets(BLonElementType.ub, 1.0F, null) );
  
  /**
   * Get the <code>valueHoursInterval</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueHoursInterval
   */
  public BLonFloat getValueHoursInterval() { return (BLonFloat)get(valueHoursInterval); }
  
  /**
   * Set the <code>valueHoursInterval</code> property.
   * @see javax.baja.lonworks.londata.BLonCpTimePeriod#valueHoursInterval
   */
  public void setValueHoursInterval(BLonFloat v) { set(valueHoursInterval,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonCpTimePeriod.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void toOutputStream(LonOutputStream out)
  {
    primitiveToOutputStream(units, out);

    switch(getUnits().getEnum().getOrdinal()) 
    {
      case BLonIntervalOfMonthEnum.IOM_MINUTE  : primitiveToOutputStream(valueMinutesInterval , out); break;
      case BLonIntervalOfMonthEnum.IOM_HOUR    : primitiveToOutputStream(valueDateOfMonth     , out); break;
      case BLonIntervalOfMonthEnum.IOM_DAY     : primitiveToOutputStream(valueHourOfDay       , out); break;
      case BLonIntervalOfMonthEnum.IOM_WEEK    : primitiveToOutputStream(valueDayOfWeek       , out); break;
      case BLonIntervalOfMonthEnum.IOM_MONTH   : primitiveToOutputStream(valueHoursInterval   , out); break;
      default : out.writeUnsigned8(0);
    }  
  }
  
  public void fromInputStream(LonInputStream in)
  {
    primitiveFromInputStream(units, in);
    
    switch(getUnits().getEnum().getOrdinal()) 
    {
      case BLonIntervalOfMonthEnum.IOM_MINUTE  : primitiveFromInputStream(valueMinutesInterval , in); break; 
      case BLonIntervalOfMonthEnum.IOM_HOUR    : primitiveFromInputStream(valueDateOfMonth     , in); break; 
      case BLonIntervalOfMonthEnum.IOM_DAY     : primitiveFromInputStream(valueHourOfDay       , in); break; 
      case BLonIntervalOfMonthEnum.IOM_WEEK    : primitiveFromInputStream(valueDayOfWeek       , in); break; 
      case BLonIntervalOfMonthEnum.IOM_MONTH   : primitiveFromInputStream(valueHoursInterval   , in); break; 
    }
  }  


}      