/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.londata;


import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This interface file is implemented by any BSimple which
 *  may be used in a BLonSimple.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  5 Sept 01
 * @version   $Revision: 2$ $Date: 9/28/01 11:22:56 AM$
 * @since     Niagara 3.0
 */
public interface BILonNetworkSimple
  extends BInterface
{  
  /**
   *  Converts data to network byte format
   */
  public void toOutputStream(LonOutputStream out);

  /**
   *  Translates from network bytes. Creates a new 
   *  BILonNetworkSimple from the next bytes read from out.
   */
  public BILonNetworkSimple fromInputStream(LonInputStream in);
  
  /**
   *  Get the network byte length.
   */
  public int getNetLength();

  public static final Type TYPE = Sys.loadType(BILonNetworkSimple.class);

}
