/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonNvTypeCategoryEnum class This file defines the
 * enumeration to be used with SNVT_hvac_type.
 *
 * @author    Robert Adams
 * @creation  10 April 02
 * @version   $Revision: 1$ $Date: 12/11/00 8:13:10 AM$
 * @since     Niagara 3.0
 */
public final class BLonNvTypeCategoryEnum
  extends BFrozenEnum
{

  /*-
  
  enum BLonNvTypeCategoryEnum
  {
    range
    {
      nvtCatInitial       = 0,
      nvtCatSignedChar    = 1,
      nvtCatUnsignedChar  = 2,
      nvtCatSignedShort   = 3,
      nvtCatUnsignedShort = 4,
      nvtCatSignedLong    = 5,
      nvtCatUnsignedLong  = 6,
      nvtCatEnum          = 7,
      nvtCatArray         = 8,
      nvtCatStruct        = 9,
      nvtCatUnion         = 10,
      nvtCatBitfield      = 11,
      nvtCatFloat         = 12,
      nvtCatSignedQuad    = 13,
      nvtCatReference     = 14,
      nvtCatNul           = -1
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonNvTypeCategoryEnum(2929337957)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for nvtCatInitial. */
  public static final int NVT_CAT_INITIAL = 0;
  /** Ordinal value for nvtCatSignedChar. */
  public static final int NVT_CAT_SIGNED_CHAR = 1;
  /** Ordinal value for nvtCatUnsignedChar. */
  public static final int NVT_CAT_UNSIGNED_CHAR = 2;
  /** Ordinal value for nvtCatSignedShort. */
  public static final int NVT_CAT_SIGNED_SHORT = 3;
  /** Ordinal value for nvtCatUnsignedShort. */
  public static final int NVT_CAT_UNSIGNED_SHORT = 4;
  /** Ordinal value for nvtCatSignedLong. */
  public static final int NVT_CAT_SIGNED_LONG = 5;
  /** Ordinal value for nvtCatUnsignedLong. */
  public static final int NVT_CAT_UNSIGNED_LONG = 6;
  /** Ordinal value for nvtCatEnum. */
  public static final int NVT_CAT_ENUM = 7;
  /** Ordinal value for nvtCatArray. */
  public static final int NVT_CAT_ARRAY = 8;
  /** Ordinal value for nvtCatStruct. */
  public static final int NVT_CAT_STRUCT = 9;
  /** Ordinal value for nvtCatUnion. */
  public static final int NVT_CAT_UNION = 10;
  /** Ordinal value for nvtCatBitfield. */
  public static final int NVT_CAT_BITFIELD = 11;
  /** Ordinal value for nvtCatFloat. */
  public static final int NVT_CAT_FLOAT = 12;
  /** Ordinal value for nvtCatSignedQuad. */
  public static final int NVT_CAT_SIGNED_QUAD = 13;
  /** Ordinal value for nvtCatReference. */
  public static final int NVT_CAT_REFERENCE = 14;
  /** Ordinal value for nvtCatNul. */
  public static final int NVT_CAT_NUL = -1;
  
  /** BLonNvTypeCategoryEnum constant for nvtCatInitial. */
  public static final BLonNvTypeCategoryEnum nvtCatInitial = new BLonNvTypeCategoryEnum(NVT_CAT_INITIAL);
  /** BLonNvTypeCategoryEnum constant for nvtCatSignedChar. */
  public static final BLonNvTypeCategoryEnum nvtCatSignedChar = new BLonNvTypeCategoryEnum(NVT_CAT_SIGNED_CHAR);
  /** BLonNvTypeCategoryEnum constant for nvtCatUnsignedChar. */
  public static final BLonNvTypeCategoryEnum nvtCatUnsignedChar = new BLonNvTypeCategoryEnum(NVT_CAT_UNSIGNED_CHAR);
  /** BLonNvTypeCategoryEnum constant for nvtCatSignedShort. */
  public static final BLonNvTypeCategoryEnum nvtCatSignedShort = new BLonNvTypeCategoryEnum(NVT_CAT_SIGNED_SHORT);
  /** BLonNvTypeCategoryEnum constant for nvtCatUnsignedShort. */
  public static final BLonNvTypeCategoryEnum nvtCatUnsignedShort = new BLonNvTypeCategoryEnum(NVT_CAT_UNSIGNED_SHORT);
  /** BLonNvTypeCategoryEnum constant for nvtCatSignedLong. */
  public static final BLonNvTypeCategoryEnum nvtCatSignedLong = new BLonNvTypeCategoryEnum(NVT_CAT_SIGNED_LONG);
  /** BLonNvTypeCategoryEnum constant for nvtCatUnsignedLong. */
  public static final BLonNvTypeCategoryEnum nvtCatUnsignedLong = new BLonNvTypeCategoryEnum(NVT_CAT_UNSIGNED_LONG);
  /** BLonNvTypeCategoryEnum constant for nvtCatEnum. */
  public static final BLonNvTypeCategoryEnum nvtCatEnum = new BLonNvTypeCategoryEnum(NVT_CAT_ENUM);
  /** BLonNvTypeCategoryEnum constant for nvtCatArray. */
  public static final BLonNvTypeCategoryEnum nvtCatArray = new BLonNvTypeCategoryEnum(NVT_CAT_ARRAY);
  /** BLonNvTypeCategoryEnum constant for nvtCatStruct. */
  public static final BLonNvTypeCategoryEnum nvtCatStruct = new BLonNvTypeCategoryEnum(NVT_CAT_STRUCT);
  /** BLonNvTypeCategoryEnum constant for nvtCatUnion. */
  public static final BLonNvTypeCategoryEnum nvtCatUnion = new BLonNvTypeCategoryEnum(NVT_CAT_UNION);
  /** BLonNvTypeCategoryEnum constant for nvtCatBitfield. */
  public static final BLonNvTypeCategoryEnum nvtCatBitfield = new BLonNvTypeCategoryEnum(NVT_CAT_BITFIELD);
  /** BLonNvTypeCategoryEnum constant for nvtCatFloat. */
  public static final BLonNvTypeCategoryEnum nvtCatFloat = new BLonNvTypeCategoryEnum(NVT_CAT_FLOAT);
  /** BLonNvTypeCategoryEnum constant for nvtCatSignedQuad. */
  public static final BLonNvTypeCategoryEnum nvtCatSignedQuad = new BLonNvTypeCategoryEnum(NVT_CAT_SIGNED_QUAD);
  /** BLonNvTypeCategoryEnum constant for nvtCatReference. */
  public static final BLonNvTypeCategoryEnum nvtCatReference = new BLonNvTypeCategoryEnum(NVT_CAT_REFERENCE);
  /** BLonNvTypeCategoryEnum constant for nvtCatNul. */
  public static final BLonNvTypeCategoryEnum nvtCatNul = new BLonNvTypeCategoryEnum(NVT_CAT_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonNvTypeCategoryEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonNvTypeCategoryEnum make(int ordinal)
  {
    return (BLonNvTypeCategoryEnum)nvtCatInitial.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonNvTypeCategoryEnum make(String tag)
  {
    return (BLonNvTypeCategoryEnum)nvtCatInitial.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonNvTypeCategoryEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
