/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonNilEnum class is a dummy enum to service as a 
 * place holder in slots where the enum type is not known.
 *
 * @author    Robert Adams
 * @creation  6 April 04
 * @version   $Revision: 4$ $Date: 9/18/01 9:49:32 AM$
 * @since     Niagara 3.0
 */
public final class BLonNilEnum
  extends BFrozenEnum
{

  /*-
  
  enum BLonNilEnum
  {
    range
    {
      nil    
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonNilEnum(423053401)1.0$ @*/
/* Generated Tue Apr 06 13:31:16 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for nil. */
  public static final int NIL = 0;
  
  /** BLonNilEnum constant for nil. */
  public static final BLonNilEnum nil = new BLonNilEnum(NIL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonNilEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonNilEnum make(int ordinal)
  {
    return (BLonNilEnum)nil.getRange().get(ordinal);
  }
  
  /** Factory method with tag. */
  public static BLonNilEnum make(String tag)
  {
    return (BLonNilEnum)nil.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonNilEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
