/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonInterpEnum class provides enumeration for SNVT_trans_table
 *
 * @author    Sean Morton
 * @creation  19 Jul 01
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:31 PM$
 * @since     Niagara 3.0
 */
public final class BLonInterpEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonInterpEnum
  {
    range
    {
      ipLinear = 0,
      ipCubicSpline = 1,
      ipReserved = 2,
      ipNul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonInterpEnum(2633476360)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for ipLinear. */
  public static final int IP_LINEAR = 0;
  /** Ordinal value for ipCubicSpline. */
  public static final int IP_CUBIC_SPLINE = 1;
  /** Ordinal value for ipReserved. */
  public static final int IP_RESERVED = 2;
  /** Ordinal value for ipNul. */
  public static final int IP_NUL = -1;
  
  /** BLonInterpEnum constant for ipLinear. */
  public static final BLonInterpEnum ipLinear = new BLonInterpEnum(IP_LINEAR);
  /** BLonInterpEnum constant for ipCubicSpline. */
  public static final BLonInterpEnum ipCubicSpline = new BLonInterpEnum(IP_CUBIC_SPLINE);
  /** BLonInterpEnum constant for ipReserved. */
  public static final BLonInterpEnum ipReserved = new BLonInterpEnum(IP_RESERVED);
  /** BLonInterpEnum constant for ipNul. */
  public static final BLonInterpEnum ipNul = new BLonInterpEnum(IP_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonInterpEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonInterpEnum make(int ordinal)
  {
    return (BLonInterpEnum)ipLinear.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonInterpEnum make(String tag)
  {
    return (BLonInterpEnum)ipLinear.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonInterpEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
