/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonExControlEnum represents Lonworks standard enumeration ExControlT.
 *
 * @author    Robert Adams
 * @creation  12 Jan 01
 * @version   $Revision: 4$ $Date: 9/18/01 9:49:32 AM$
 * @since     Niagara 3.0
 */
public final class BLonExControlEnum
  extends BFrozenEnum
{

  /*-
  
  enum BLonExControlEnum
  {
    range
    {
      exControlNone = 0,
      exControlOther = 1,
      exControlThisAddr = 2,
      exControlNul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonExControlEnum(3518854225)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for exControlNone. */
  public static final int EX_CONTROL_NONE = 0;
  /** Ordinal value for exControlOther. */
  public static final int EX_CONTROL_OTHER = 1;
  /** Ordinal value for exControlThisAddr. */
  public static final int EX_CONTROL_THIS_ADDR = 2;
  /** Ordinal value for exControlNul. */
  public static final int EX_CONTROL_NUL = -1;
  
  /** BLonExControlEnum constant for exControlNone. */
  public static final BLonExControlEnum exControlNone = new BLonExControlEnum(EX_CONTROL_NONE);
  /** BLonExControlEnum constant for exControlOther. */
  public static final BLonExControlEnum exControlOther = new BLonExControlEnum(EX_CONTROL_OTHER);
  /** BLonExControlEnum constant for exControlThisAddr. */
  public static final BLonExControlEnum exControlThisAddr = new BLonExControlEnum(EX_CONTROL_THIS_ADDR);
  /** BLonExControlEnum constant for exControlNul. */
  public static final BLonExControlEnum exControlNul = new BLonExControlEnum(EX_CONTROL_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonExControlEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonExControlEnum make(int ordinal)
  {
    return (BLonExControlEnum)exControlNone.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonExControlEnum make(String tag)
  {
    return (BLonExControlEnum)exControlNone.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonExControlEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
