/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonEvapEnum class provides enumeration for SNVT_evap_state
 *
 * @author    Sean Morton
 * @creation  18 Jul 01
 * @version   $Revision: 1$ $Date: 8/9/01 2:22:27 PM$
 * @since     Niagara 3.0
 */
public final class BLonEvapEnum
  extends BFrozenEnum
{
  /*-
  
  enum BLonEvapEnum
  {
    range
    {
      evapNoCooling = 0,
      evapCooling = 1,
      evapEmergCooling = 2,
      evapNul = -1,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonEvapEnum(563817411)1.0$ @*/
/* Generated Wed Apr 19 15:20:48 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for evapNoCooling. */
  public static final int EVAP_NO_COOLING = 0;
  /** Ordinal value for evapCooling. */
  public static final int EVAP_COOLING = 1;
  /** Ordinal value for evapEmergCooling. */
  public static final int EVAP_EMERG_COOLING = 2;
  /** Ordinal value for evapNul. */
  public static final int EVAP_NUL = -1;
  
  /** BLonEvapEnum constant for evapNoCooling. */
  public static final BLonEvapEnum evapNoCooling = new BLonEvapEnum(EVAP_NO_COOLING);
  /** BLonEvapEnum constant for evapCooling. */
  public static final BLonEvapEnum evapCooling = new BLonEvapEnum(EVAP_COOLING);
  /** BLonEvapEnum constant for evapEmergCooling. */
  public static final BLonEvapEnum evapEmergCooling = new BLonEvapEnum(EVAP_EMERG_COOLING);
  /** BLonEvapEnum constant for evapNul. */
  public static final BLonEvapEnum evapNul = new BLonEvapEnum(EVAP_NUL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonEvapEnum.class);
  
  /** Factory method with ordinal. */
  public static BLonEvapEnum make(int ordinal)
  {
    return (BLonEvapEnum)evapNoCooling.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLonEvapEnum make(String tag)
  {
    return (BLonEvapEnum)evapNoCooling.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonEvapEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
