/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonConfigScope class specifies the scope of a ConfigParameter.
 *
 * @author    Robert Adams
 * @creation  12 Jan 01
 * @version   $Revision: 4$ $Date: 9/18/01 9:49:32 AM$
 * @since     Niagara 3.0
 */
public final class BLonConfigScope
  extends BFrozenEnum
{

  /*-
  
  enum BLonConfigScope
  {
    range
    {
      node,  
      object,
      nv    
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.lonworks.enums.BLonConfigScope(2726441924)1.0$ @*/
/* Generated Tue Apr 06 10:08:40 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for node. */
  public static final int NODE = 0;
  /** Ordinal value for object. */
  public static final int OBJECT = 1;
  /** Ordinal value for nv. */
  public static final int NV = 2;
  
  /** BLonConfigScope constant for node. */
  public static final BLonConfigScope node = new BLonConfigScope(NODE);
  /** BLonConfigScope constant for object. */
  public static final BLonConfigScope object = new BLonConfigScope(OBJECT);
  /** BLonConfigScope constant for nv. */
  public static final BLonConfigScope nv = new BLonConfigScope(NV);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLonConfigScope.class);
  
  /** Factory method with ordinal. */
  public static BLonConfigScope make(int ordinal)
  {
    return (BLonConfigScope)node.getRange().get(ordinal);
  }
  
  /** Factory method with tag. */
  public static BLonConfigScope make(String tag)
  {
    return (BLonConfigScope)node.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLonConfigScope(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
